/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.playlist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.SavePlayListAction;
import net.sourceforge.atunes.kernel.actions.ShufflePlayListAction;
import net.sourceforge.atunes.kernel.modules.columns.PlayListColumnSet;
import net.sourceforge.atunes.kernel.modules.filter.AbstractFilter;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.playlist.ListOfPlayLists;
import net.sourceforge.atunes.kernel.modules.playlist.LoadPlayListProcess;
import net.sourceforge.atunes.kernel.modules.playlist.PlayList;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListEventListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListTableModel;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.AudioFilesRemovedListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class PlayListHandler
extends AbstractHandler
implements AudioFilesRemovedListener {
    private static PlayListHandler instance = new PlayListHandler();
    private static int playListNameCounter = 1;
    private List<PlayList> playLists = new ArrayList<PlayList>();
    private int activePlayListIndex = 0;
    private int visiblePlayListIndex = 0;
    private static PlayList nonFilteredPlayList;
    private static ListOfPlayLists playListsRetrievedFromCache;
    private boolean playListsChanged;
    private List<PlayListEventListener> playListEventListeners = new ArrayList<PlayListEventListener>();
    private AbstractFilter playListFilter = new AbstractFilter(){

        @Override
        public String getName() {
            return "PLAYLIST";
        }

        @Override
        public String getDescription() {
            return I18nUtils.getString("PLAYLIST");
        }

        @Override
        public void applyFilter(String string) {
            PlayListHandler.this.setFilter(string);
        }
    };

    private PlayListHandler() {
    }

    @Override
    protected void initHandler() {
        RepositoryHandler.getInstance().addAudioFilesRemovedListener(this);
    }

    @Override
    public void applicationStarted() {
    }

    public static PlayListHandler getInstance() {
        return instance;
    }

    public static void setVisiblePlayListActive() {
        PlayListHandler.instance.activePlayListIndex = PlayListHandler.instance.visiblePlayListIndex;
    }

    public void removePlayList(int n) {
        if (n < 0 || this.playLists.size() <= n) {
            return;
        }
        if (this.playLists.size() <= 1) {
            return;
        }
        this.playListsChanged = true;
        if (n != this.visiblePlayListIndex) {
            boolean bl;
            this.playLists.remove(n);
            boolean bl2 = bl = n == this.activePlayListIndex;
            if (n < this.visiblePlayListIndex) {
                if (this.activePlayListIndex == this.visiblePlayListIndex) {
                    --this.activePlayListIndex;
                }
                --this.visiblePlayListIndex;
            }
            if (bl) {
                this.activePlayListIndex = this.visiblePlayListIndex;
                PlayerHandler.getInstance().stopCurrentAudioObject(false);
            }
            ControllerProxy.getInstance().getPlayListTabController().deletePlayList(n);
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        } else {
            if (n == 0) {
                this.switchToPlaylist(1);
            } else {
                this.switchToPlaylist(this.visiblePlayListIndex - 1);
            }
            this.removePlayList(n);
        }
    }

    private ListOfPlayLists getListOfPlayLists() {
        ListOfPlayLists listOfPlayLists = new ListOfPlayLists();
        listOfPlayLists.setPlayLists(new ArrayList<PlayList>(this.playLists));
        listOfPlayLists.setSelectedPlayList(this.activePlayListIndex);
        if (this.isFiltered()) {
            listOfPlayLists.getPlayLists().remove(this.activePlayListIndex);
            listOfPlayLists.getPlayLists().add(this.activePlayListIndex, nonFilteredPlayList);
        }
        return listOfPlayLists;
    }

    public int getPlayListCount() {
        return this.playLists.size();
    }

    private String getNameForPlaylist(PlayList playList) {
        if (playList == null || playList.getName() == null) {
            String string = StringUtils.getString(I18nUtils.getString("PLAYLIST"), " ", playListNameCounter++);
            for (PlayList playList2 : this.playLists) {
                if (playList2.getName() == null || !string.equalsIgnoreCase(playList2.getName().trim())) continue;
                return this.getNameForPlaylist(playList);
            }
            return string;
        }
        return playList.getName();
    }

    public void newPlayList(List<AudioObject> list) {
        this.newPlayList(this.getNameForPlaylist(null), list);
    }

    public void newPlayList(String string, List<AudioObject> list) {
        PlayList playList = list == null ? new PlayList() : new PlayList(list);
        playList.setName(string);
        this.playLists.add(playList);
        ControllerProxy.getInstance().getPlayListTabController().newPlayList(string);
        this.playListsChanged = true;
    }

    public void renamePlayList(int n, String string) {
        this.playLists.get(n).setName(string);
        ControllerProxy.getInstance().getPlayListTabController().renamePlayList(n, string);
    }

    public void switchToPlaylist(int n) {
        if (n == this.visiblePlayListIndex) {
            return;
        }
        if (ApplicationState.getInstance().isStopPlayerOnPlayListSwitch()) {
            PlayerHandler.getInstance().stopCurrentAudioObject(false);
        }
        this.setFilter(null);
        this.visiblePlayListIndex = n;
        PlayList playList = this.playLists.get(n);
        GuiHandler.getInstance().getPlayListTable().getSelectionModel().clearSelection();
        PlayListHandler.setPlayList(playList);
        ((PlayListTableModel)GuiHandler.getInstance().getPlayListTable().getModel()).setVisiblePlayList(this.getCurrentPlayList(true));
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        if (PlayListHandler.getInstance().isActivePlayListVisible()) {
            ControllerProxy.getInstance().getPlayListController().scrollPlayList(false);
        }
    }

    private static void setPlayList(PlayList playList) {
        Actions.getAction(SavePlayListAction.class).setEnabled(!instance.getCurrentPlayList(true).isEmpty());
        Actions.getAction(ShufflePlayListAction.class).setEnabled(!instance.getCurrentPlayList(true).isEmpty());
        GuiHandler.getInstance().showPlayListInformation(playList);
        if (PlayListHandler.getInstance().isActivePlayListVisible()) {
            PlayListHandler.getInstance().selectedAudioObjectHasChanged(playList.getCurrentAudioObject());
        }
    }

    public boolean isVisiblePlayList(int n) {
        return this.visiblePlayListIndex == n;
    }

    public AudioObject getCurrentAudioObjectFromVisiblePlayList() {
        if (this.getCurrentPlayList(true) != null) {
            return this.getCurrentPlayList(true).getCurrentAudioObject();
        }
        return null;
    }

    public AudioObject getCurrentAudioObjectFromCurrentPlayList() {
        if (this.getCurrentPlayList(false) != null) {
            return this.getCurrentPlayList(false).getCurrentAudioObject();
        }
        return null;
    }

    public PlayList getCurrentPlayList(boolean bl) {
        if (this.playLists.isEmpty()) {
            return null;
        }
        if (bl) {
            return this.playLists.get(this.visiblePlayListIndex);
        }
        return this.playLists.get(this.activePlayListIndex);
    }

    public void addToPlayList(List<? extends AudioObject> list) {
        this.addToPlayList(this.getCurrentPlayList(true).size(), list, true);
    }

    public void addToPlayList(int n, List<? extends AudioObject> list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return;
        }
        PlayList playList = this.getCurrentPlayList(bl);
        if (this.isFiltered()) {
            this.setFilter(null);
        }
        int n2 = n;
        if (n < 0 || n > playList.size()) {
            n2 = playList.size();
        }
        playList.add(n2, list);
        if (this.isActivePlayListVisible() && playList.size() == list.size()) {
            int n3 = 0;
            if (!ApplicationState.getInstance().isStopPlayerOnPlayListClear() && PlayerHandler.getInstance().isEnginePlaying()) {
                int n4 = playList.indexOf(PlayerHandler.getInstance().getAudioObject());
                if (n4 != -1) {
                    n3 = n4;
                } else {
                    PlayerHandler.getInstance().stopCurrentAudioObject(false);
                }
            } else if (ApplicationState.getInstance().isShuffle()) {
                n3 = playList.getRandomPosition();
            }
            this.selectedAudioObjectHasChanged(list.get(n3));
            playList.setCurrentAudioObjectIndex(n3);
        }
        Actions.getAction(SavePlayListAction.class).setEnabled(!this.getCurrentPlayList(true).isEmpty());
        Actions.getAction(ShufflePlayListAction.class).setEnabled(!this.getCurrentPlayList(true).isEmpty());
        GuiHandler.getInstance().showPlayListInformation(playList);
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        PlayListHandler.getLogger().info("HANDLER     ", StringUtils.getString(list.size(), " audio objects added to play list"));
    }

    public void addToActivePlayList(List<? extends AudioObject> list) {
        PlayList playList = this.getCurrentPlayList(false);
        this.addToPlayList(playList.getCurrentAudioObjectIndex() + 1, list, false);
    }

    public void clearPlayList() {
        PlayListHandler.getLogger().debug("HANDLER     ");
        this.setFilter(null);
        GuiHandler.getInstance().getPlayListTable().getSelectionModel().clearSelection();
        PlayList playList = this.getCurrentPlayList(true);
        if (!playList.isEmpty()) {
            playList.clear();
            if (this.isActivePlayListVisible() && ApplicationState.getInstance().isStopPlayerOnPlayListClear()) {
                PlayerHandler.getInstance().stopCurrentAudioObject(false);
            }
            playList.setCurrentAudioObjectIndex(0);
            Actions.getAction(SavePlayListAction.class).setEnabled(false);
            Actions.getAction(ShufflePlayListAction.class).setEnabled(false);
            GuiHandler.getInstance().showPlayListInformation(playList);
            if (!ApplicationState.getInstance().isStopPlayerOnPlayListClear()) {
                GuiHandler.getInstance().getPlayerControls().getProgressBar().setEnabled(false);
            } else {
                GuiHandler.getInstance().getPlayerControls().setShowTicksAndLabels(false);
            }
            GuiHandler.getInstance().getPlayListPanel().repaint();
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
            PlayListHandler.getLogger().info("HANDLER     ", "Play list clear");
        }
        if (this.isActivePlayListVisible()) {
            this.clear();
        }
    }

    @Override
    public void applicationFinish() {
        boolean bl = false;
        for (PlayList playList : this.playLists) {
            bl = bl || playList.isDirty();
        }
        if (bl || this.playListsChanged) {
            ApplicationStateHandler.getInstance().persistPlayListsDefinition(this.getListOfPlayLists());
            ApplicationStateHandler.getInstance().persistPlayListsContents(this.getPlayListsContents());
        } else {
            PlayListHandler.getLogger().info("PLAYLIST    ", "Playlists are clean");
        }
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new PreviousInitializationTaskRunnable();
    }

    public void setPlayLists() {
        PlayListHandler.getLogger().debug("HANDLER     ");
        ListOfPlayLists listOfPlayLists = playListsRetrievedFromCache;
        int n = listOfPlayLists.getSelectedPlayList();
        if (n < 0 || n >= listOfPlayLists.getPlayLists().size()) {
            n = 0;
        }
        PlayList playList = listOfPlayLists.getPlayLists().get(n);
        this.playLists.clear();
        for (PlayList playList2 : listOfPlayLists.getPlayLists()) {
            this.playLists.add(playList2);
            ControllerProxy.getInstance().getPlayListTabController().newPlayList(this.getNameForPlaylist(playList2));
        }
        this.visiblePlayListIndex = this.activePlayListIndex = n;
        ControllerProxy.getInstance().getPlayListTabController().forceSwitchTo(this.visiblePlayListIndex);
        PlayListHandler.setPlayList(this.playLists.get(this.activePlayListIndex));
        if (playList.size() > 0 && (playList.get(0) instanceof Radio || playList.get(0) instanceof PodcastFeedEntry || playList.get(0) instanceof AudioFile)) {
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>(playList.getAudioObjects());
            for (int i = 0; i < arrayList.size(); ++i) {
                AudioObject audioObject = (AudioObject)arrayList.get(i);
                AudioFile audioFile = RepositoryHandler.getInstance().getFileIfLoaded(audioObject.getUrl());
                if (audioFile == null) continue;
                playList.replace(i, audioFile);
            }
        }
        ((PlayListTableModel)GuiHandler.getInstance().getPlayListTable().getModel()).setVisiblePlayList(this.getCurrentPlayList(true));
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        playListsRetrievedFromCache = null;
    }

    public void loadPlaylist() {
        PlayListHandler.getLogger().debug("HANDLER     ");
        JFileChooser jFileChooser = new JFileChooser(ApplicationState.getInstance().getLoadPlaylistPath());
        FileFilter fileFilter = PlayListIO.getPlaylistFileFilter();
        if (GuiHandler.getInstance().showOpenDialog(jFileChooser, fileFilter) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                ApplicationState.getInstance().setLoadPlaylistPath(file.getParentFile().getAbsolutePath());
                List<String> list = PlayListIO.read(file);
                if (list != null) {
                    LoadPlayListProcess loadPlayListProcess = new LoadPlayListProcess(list);
                    loadPlayListProcess.execute();
                }
            } else {
                GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("FILE_NOT_FOUND"));
            }
        }
    }

    private void moveRows(int[] nArray, boolean bl) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        Collections.sort(arrayList, new RowListComparator(bl));
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Integer n = (Integer)object.next();
            this.moveRowTo(n, n + (bl ? -1 : 1));
        }
    }

    public void moveUp(int[] nArray) {
        this.moveRows(nArray, true);
    }

    public void moveDown(int[] nArray) {
        this.moveRows(nArray, false);
    }

    public void moveToBottom(int[] nArray) {
        PlayListHandler.getLogger().debug("HANDLER     ");
        PlayList playList = this.getCurrentPlayList(true);
        int n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            AudioObject audioObject = playList.get(nArray[i]);
            playList.remove(nArray[i]);
            playList.add(playList.size() - n++, audioObject);
        }
        if (nArray[nArray.length - 1] < playList.getCurrentAudioObjectIndex()) {
            playList.setCurrentAudioObjectIndex(playList.getCurrentAudioObjectIndex() - nArray.length);
        } else if (nArray[0] <= playList.getCurrentAudioObjectIndex() && playList.getCurrentAudioObjectIndex() <= nArray[nArray.length - 1]) {
            playList.setCurrentAudioObjectIndex(playList.getCurrentAudioObjectIndex() + playList.size() - nArray[nArray.length - 1] - 1);
        }
    }

    public void moveToTop(int[] nArray) {
        PlayListHandler.getLogger().debug("HANDLER     ");
        PlayList playList = this.getCurrentPlayList(true);
        for (int i = 0; i < nArray.length; ++i) {
            AudioObject audioObject = playList.get(nArray[i]);
            playList.remove(nArray[i]);
            playList.add(i, audioObject);
        }
        if (nArray[0] > playList.getCurrentAudioObjectIndex()) {
            playList.setCurrentAudioObjectIndex(playList.getCurrentAudioObjectIndex() + nArray.length);
        } else if (nArray[0] <= playList.getCurrentAudioObjectIndex() && playList.getCurrentAudioObjectIndex() <= nArray[nArray.length - 1]) {
            playList.setCurrentAudioObjectIndex(playList.getCurrentAudioObjectIndex() - nArray[0]);
        }
    }

    public void moveRowTo(int n, int n2) {
        this.getCurrentPlayList(true).moveRowTo(n, n2);
    }

    public void playNow(AudioObject audioObject) {
        if (!this.getCurrentPlayList(true).contains(audioObject)) {
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
            arrayList.add(audioObject);
            this.addToPlayListAndPlay(arrayList);
        } else {
            this.setPositionToPlayInVisiblePlayList(this.getCurrentPlayList(true).indexOf(audioObject));
            PlayerHandler.getInstance().playCurrentAudioObject(false);
        }
    }

    public void removeAudioObjects(int[] nArray) {
        PlayList playList = this.getCurrentPlayList(true);
        AudioObject audioObject = playList.getCurrentAudioObject();
        boolean bl = false;
        for (int n : nArray) {
            if (n != playList.getCurrentAudioObjectIndex()) continue;
            bl = true;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            playList.remove(nArray[i]);
        }
        if (bl) {
            if (this.isActivePlayListVisible()) {
                PlayerHandler.getInstance().stopCurrentAudioObject(false);
            }
            if (playList.isEmpty()) {
                this.clear();
            } else {
                if (playList.getCurrentAudioObjectIndex() >= playList.size()) {
                    playList.setCurrentAudioObjectIndex(playList.size() - 1);
                }
                if (this.isActivePlayListVisible()) {
                    this.selectedAudioObjectHasChanged(playList.getCurrentAudioObject());
                }
            }
        } else {
            playList.setCurrentAudioObjectIndex(playList.indexOf(audioObject));
            if (this.isActivePlayListVisible()) {
                this.selectedAudioObjectHasChanged(playList.getCurrentAudioObject());
            }
        }
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        if (playList.isEmpty()) {
            Actions.getAction(SavePlayListAction.class).setEnabled(false);
            Actions.getAction(ShufflePlayListAction.class).setEnabled(false);
            GuiHandler.getInstance().getPlayerControls().setShowTicksAndLabels(false);
        }
        GuiHandler.getInstance().showPlayListInformation(playList);
        PlayListHandler.getLogger().info("HANDLER     ", StringUtils.getString(nArray.length, " objects removed from play list"));
    }

    private void clear() {
        for (PlayListEventListener playListEventListener : this.playListEventListeners) {
            playListEventListener.clear();
        }
    }

    public void selectedAudioObjectHasChanged(AudioObject audioObject) {
        if (audioObject == null) {
            return;
        }
        this.addToPlaybackHistory(audioObject);
        for (PlayListEventListener playListEventListener : this.playListEventListeners) {
            playListEventListener.selectedAudioObjectChanged(audioObject);
        }
    }

    public void shuffle() {
        PlayListHandler.getLogger().debug("HANDLER     ");
        PlayList playList = this.getCurrentPlayList(true);
        if (playList.isEmpty()) {
            return;
        }
        playList.shuffle();
    }

    public boolean isActivePlayListVisible() {
        return this.getCurrentPlayList(true) == this.getCurrentPlayList(false);
    }

    public void addToPlayListAndPlay(List<AudioObject> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = this.getCurrentPlayList(true).size();
        this.addToPlayList(list);
        this.setPositionToPlayInVisiblePlayList(n);
        PlayerHandler.getInstance().playCurrentAudioObject(false);
    }

    public boolean isFiltered() {
        return nonFilteredPlayList != null;
    }

    public void setFilter(String string) {
        String string2 = string;
        if (string2 == null) {
            if (nonFilteredPlayList != null) {
                this.setPlayListAfterFiltering(nonFilteredPlayList);
                nonFilteredPlayList = null;
            }
        } else {
            if (nonFilteredPlayList == null) {
                nonFilteredPlayList = this.getCurrentPlayList(true).clone();
            }
            PlayList playList = new PlayList(PlayListColumnSet.getInstance().filterAudioObjects(nonFilteredPlayList.getAudioObjects(), string2));
            this.setPlayListAfterFiltering(playList);
        }
    }

    private void setPlayListAfterFiltering(PlayList playList) {
        this.playLists.remove(this.visiblePlayListIndex);
        this.playLists.add(this.visiblePlayListIndex, playList);
        GuiHandler.getInstance().getPlayListTable().getSelectionModel().clearSelection();
        PlayListHandler.setPlayList(playList);
        ((PlayListTableModel)GuiHandler.getInstance().getPlayListTable().getModel()).setVisiblePlayList(playList);
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        ControllerProxy.getInstance().getPlayListController().scrollPlayList(false);
    }

    public final void setPositionToPlayInVisiblePlayList(int n) {
        this.getCurrentPlayList(true).setCurrentAudioObjectIndex(n);
    }

    public final void setPositionToPlayInCurrentPlayList(int n) {
        this.getCurrentPlayList(false).setCurrentAudioObjectIndex(n);
    }

    public AudioObject getNextAudioObject() {
        return this.getCurrentPlayList(false).moveToNextAudioObject();
    }

    public AudioObject getPreviousAudioObject() {
        return this.getCurrentPlayList(false).moveToPreviousAudioObject();
    }

    public int getIndexOfAudioObject(AudioObject audioObject) {
        return this.getCurrentPlayList(false).indexOf(audioObject);
    }

    public AudioObject getAudioObjectAtIndex(int n) {
        return this.getCurrentPlayList(false).getNextAudioObject(n);
    }

    public void changeSelectedAudioObjectToIndex(int n) {
        GuiHandler.getInstance().getPlayListTable().changeSelection(n, 0, false, false);
    }

    public List<AudioObject> getSelectedAudioObjects() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        int[] nArray = GuiHandler.getInstance().getPlayListTable().getSelectedRows();
        if (nArray.length > 0) {
            for (int n : nArray) {
                AudioObject audioObject = PlayListHandler.getInstance().getCurrentPlayList(true).get(n);
                if (audioObject == null) continue;
                arrayList.add(audioObject);
            }
        }
        return arrayList;
    }

    public boolean isCurrentVisibleRowPlaying(int n) {
        return this.getCurrentPlayList(true).getCurrentAudioObjectIndex() == n && this.isActivePlayListVisible();
    }

    public int getCurrentAudioObjectIndexInVisiblePlayList() {
        return this.getCurrentPlayList(true).getCurrentAudioObjectIndex();
    }

    public void addToPlaybackHistory(AudioObject audioObject) {
        this.getCurrentPlayList(false).addToPlaybackHistory(audioObject);
        PlayListHandler.getLogger().debug("PLAYLIST    ", "Added to history: ", audioObject.getTitle());
    }

    @Override
    public void audioFilesRemoved(List<AudioFile> list) {
        List<AudioObject> list2 = AudioFile.getAudioObjects(list);
        for (PlayList playList : this.playLists) {
            playList.remove(list2);
        }
        GuiHandler.getInstance().showPlayListInformation(this.getCurrentPlayList(true));
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        if (applicationState.isAutoScrollPlayListEnabled()) {
            ControllerProxy.getInstance().getPlayListController().scrollPlayList(true);
        }
    }

    public void movePlaylistToPosition(int n, int n2) {
        PlayList playList = this.playLists.get(this.activePlayListIndex);
        PlayList playList2 = this.playLists.get(this.visiblePlayListIndex);
        PlayList playList3 = this.playLists.remove(n);
        this.playLists.add(n2, playList3);
        this.activePlayListIndex = this.playLists.indexOf(playList);
        this.visiblePlayListIndex = this.playLists.indexOf(playList2);
    }

    private List<List<AudioObject>> getPlayListsContents() {
        ArrayList<List<AudioObject>> arrayList = new ArrayList<List<AudioObject>>(this.playLists.size());
        for (PlayList playList : this.playLists) {
            arrayList.add(playList.getAudioObjects());
        }
        return arrayList;
    }

    public AbstractFilter getPlayListFilter() {
        return this.playListFilter;
    }

    public String getPlayListNameAtIndex(int n) {
        return this.playLists.get(n).getName();
    }

    public List<AudioObject> getPlayListContent(int n) {
        if (n >= this.playLists.size()) {
            throw new IllegalArgumentException("Invalid play list index " + n);
        }
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        PlayList playList = this.playLists.get(n);
        for (int i = 0; i < playList.size(); ++i) {
            arrayList.add(playList.get(i));
        }
        return arrayList;
    }

    public void addPlayListEventListener(PlayListEventListener playListEventListener) {
        this.playListEventListeners.add(playListEventListener);
    }

    private static class PreviousInitializationTaskRunnable
    implements Runnable {
        private PreviousInitializationTaskRunnable() {
        }

        @Override
        public void run() {
            playListsRetrievedFromCache = ApplicationStateHandler.getInstance().retrievePlayListsCache();
        }
    }

    private static final class RowListComparator
    implements Comparator<Integer> {
        private final boolean up;

        private RowListComparator(boolean bl) {
            this.up = bl;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            return (this.up ? 1 : -1) * n.compareTo(n2);
        }
    }
}

