/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.player.mplayer.AudioFileMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.mplayer.PodcastFeedEntryMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.RadioMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;

abstract class AbstractMPlayerOutputReader
extends Thread {
    private static final Pattern END_PATTERN = Pattern.compile(".*\\x2e\\x2e\\x2e\\x20\\(.*\\x20.*\\).*");
    private Logger logger;
    private MPlayerEngine engine;
    private BufferedReader in;
    private int length;
    private int time;
    private volatile boolean readStopped = false;

    protected AbstractMPlayerOutputReader(MPlayerEngine mPlayerEngine, Process process) {
        this.engine = mPlayerEngine;
        this.in = new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    static AbstractMPlayerOutputReader newInstance(MPlayerEngine mPlayerEngine, Process process, AudioObject audioObject) {
        if (audioObject instanceof AudioFile) {
            return new AudioFileMPlayerOutputReader(mPlayerEngine, process, (AudioFile)audioObject);
        }
        if (audioObject instanceof Radio) {
            return new RadioMPlayerOutputReader(mPlayerEngine, process, (Radio)audioObject);
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return new PodcastFeedEntryMPlayerOutputReader(mPlayerEngine, process, (PodcastFeedEntry)audioObject);
        }
        throw new IllegalArgumentException("audio object is not from type AudioFile, Radio or PodcastFeedEntry");
    }

    protected void init() {
    }

    protected void read(String string) {
        if (string.contains("ANS_TIME_POSITION")) {
            this.setTime((int)((double)Float.parseFloat(string.substring(string.indexOf(61) + 1)) * 1000.0));
            this.getEngine().setTime(this.getTime());
        }
        if (END_PATTERN.matcher(string).matches() && !this.readStopped) {
            this.getEngine().currentAudioObjectFinished(true, new String[0]);
        }
    }

    protected void stopRead() {
        this.readStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String string = null;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractMPlayerOutputReader.this.init();
                }
            });
            while ((string = this.in.readLine()) != null && !this.isInterrupted()) {
                final String string2 = string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractMPlayerOutputReader.this.read(string2);
                    }
                });
            }
        }
        catch (IOException iOException) {
            this.getEngine().handlePlayerEngineError(iOException);
        }
        finally {
            ClosingUtils.close(this.in);
        }
    }

    protected void readAndApplyLength(AudioObject audioObject, String string, boolean bl) {
        if (string.contains("ANS_LENGTH")) {
            if (bl) {
                this.setLength(audioObject.getDuration() * 1000);
            } else {
                this.setLength((int)((double)Float.parseFloat(string.substring(string.indexOf(61) + 1)) * 1000.0));
                if (this.getLength() == 0) {
                    this.setLength(audioObject.getDuration() * 1000);
                }
            }
            this.getEngine().setCurrentLength(this.getLength());
        }
    }

    protected final void setTime(int n) {
        this.time = n;
    }

    protected final int getTime() {
        return this.time;
    }

    protected final void setLength(int n) {
        this.length = n;
    }

    protected final int getLength() {
        return this.length;
    }

    protected final MPlayerEngine getEngine() {
        return this.engine;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

