/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.instances;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.modules.command.CommandHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class MultipleInstancesHandler
extends AbstractHandler {
    private static boolean closing = false;
    private static MultipleInstancesHandler instance;
    private ServerSocket serverSocket;

    private MultipleInstancesHandler() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
    }

    @Override
    public void applicationStarted() {
    }

    public static MultipleInstancesHandler getInstance() {
        if (instance == null) {
            instance = new MultipleInstancesHandler();
        }
        return instance;
    }

    @Override
    public void applicationFinish() {
        if (this.serverSocket != null) {
            closing = true;
            ClosingUtils.close(this.serverSocket);
        }
    }

    public boolean isFirstInstance() {
        try {
            this.serverSocket = new ServerSocket(7777);
            System.out.println(StringUtils.getString("INFO: aTunes is listening for other instances on port ", 7777));
            SongsQueue songsQueue = new SongsQueue();
            SocketListener socketListener = new SocketListener(this.serverSocket, songsQueue);
            songsQueue.start();
            socketListener.start();
            return true;
        }
        catch (Exception exception) {
            System.out.println("INFO: Another aTunes instance is running");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendArgumentsToFirstInstance(List<String> list) {
        block7: {
            Socket socket = null;
            PrintWriter printWriter = null;
            try {
                socket = new Socket("localhost", 7777);
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                for (String string : list) {
                    if (AudioFile.isValidAudioFile(string) || PlayListIO.isValidPlayList(string)) {
                        System.out.println(StringUtils.getString("INFO: Sending arg \"", string, "\""));
                        printWriter.write(string);
                        continue;
                    }
                    if (!CommandHandler.getInstance().isCommand(string)) continue;
                    System.out.println(StringUtils.getString("INFO: Sending command \"", string, "\""));
                    printWriter.write(string);
                }
                ClosingUtils.close(printWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block7;
            }
            finally {
                ClosingUtils.close(printWriter);
                ClosingUtils.close(socket);
            }
            ClosingUtils.close(socket);
        }
    }

    static class SongsQueue
    extends Thread {
        private List<AudioObject> songsQueue = new ArrayList<AudioObject>();
        private long lastSongAdded = 0L;

        SongsQueue() {
        }

        public void addSong(AudioObject audioObject) {
            this.songsQueue.add(audioObject);
            this.lastSongAdded = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (!this.songsQueue.isEmpty() && this.lastSongAdded < System.currentTimeMillis() - 1000L) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>(SongsQueue.this.songsQueue);
                                SongsQueue.this.songsQueue.clear();
                                PlayListHandler.getInstance().addToPlayListAndPlay(arrayList);
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
    }

    static class SocketListener
    extends Thread {
        private ServerSocket socket;
        private SongsQueue queue;

        SocketListener(ServerSocket serverSocket, SongsQueue songsQueue) {
            this.socket = serverSocket;
            this.queue = songsQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket socket = null;
            BufferedReader bufferedReader = null;
            Closeable closeable = null;
            try {
                try {
                    while (true) {
                        String string;
                        socket = this.socket.accept();
                        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        while ((string = bufferedReader.readLine()) != null) {
                            Object object;
                            File file = new File(string);
                            MultipleInstancesHandler.getLogger().info("HANDLER     ", StringUtils.getString("Received connection with content: \"", string, "\""));
                            if (PlayListIO.isValidPlayList(file)) {
                                object = PlayListIO.read(file);
                                List<AudioObject> list = PlayListIO.getAudioObjectsFromFileNamesList(object);
                                for (AudioObject audioObject : list) {
                                    this.queue.addSong(audioObject);
                                }
                                continue;
                            }
                            if (AudioFile.isValidAudioFile(file)) {
                                object = RepositoryHandler.getInstance().getFileIfLoaded(string);
                                if (object == null) {
                                    object = new AudioFile(file);
                                }
                                this.queue.addSong((AudioObject)object);
                                continue;
                            }
                            if (!CommandHandler.getInstance().isValidCommand(string)) continue;
                            CommandHandler.getInstance().processAndRun(string);
                        }
                        ClosingUtils.close(bufferedReader);
                        ClosingUtils.close(socket);
                        MultipleInstancesHandler.getLogger().info("HANDLER     ", StringUtils.getString("Connection finished"));
                    }
                }
                catch (IOException iOException) {
                    if (!closing) {
                        MultipleInstancesHandler.getLogger().error("HANDLER     ", iOException);
                    }
                    ClosingUtils.close(closeable);
                    ClosingUtils.close(bufferedReader);
                    ClosingUtils.close(socket);
                }
            }
            catch (Throwable throwable) {
                ClosingUtils.close(closeable);
                ClosingUtils.close(bufferedReader);
                ClosingUtils.close(socket);
                throw throwable;
            }
        }
    }
}

