/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.hotkeys;

import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.MuteAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.hotkeys.AbstractHotkeys;
import net.sourceforge.atunes.kernel.modules.hotkeys.Hotkey;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyListener;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeysConfig;
import net.sourceforge.atunes.kernel.modules.notify.NotifyHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class HotkeyHandler
extends AbstractHandler
implements HotkeyListener {
    private static HotkeyHandler instance;
    private static final int RIGHT_ARROW = 39;
    private static final int LEFT_ARROW = 37;
    private static final int UP_ARROW = 38;
    private static final int DOWN_ARROW = 40;
    public static final int HOTKEY_NEXT = 1;
    public static final int HOTKEY_PREVIOUS = 2;
    public static final int HOTKEY_VOLUME_UP = 3;
    public static final int HOTKEY_VOLUME_DOWN = 4;
    public static final int HOTKEY_PAUSE = 5;
    public static final int HOTKEY_STOP = 6;
    public static final int HOTKEY_TOGGLE_WINDOW_VISIBILITY = 7;
    public static final int HOTKEY_MUTE = 8;
    public static final int HOTKEY_SHOW_OSD = 9;
    private boolean supported;
    private boolean enabled;
    private AbstractHotkeys hotkeys;
    private HotkeysConfig hotkeysConfig;
    private static final HotkeysConfig DEFAULT_HOTKEYS_CONFIG;

    private HotkeyHandler() {
    }

    @Override
    protected void initHandler() {
        this.hotkeys = AbstractHotkeys.createInstance(this);
        HotkeysConfig hotkeysConfig = ApplicationState.getInstance().getHotkeysConfig();
        HotkeysConfig hotkeysConfig2 = this.hotkeysConfig = hotkeysConfig != null ? hotkeysConfig : DEFAULT_HOTKEYS_CONFIG;
        if (this.hotkeys != null) {
            this.supported = true;
        } else {
            this.supported = false;
            HotkeyHandler.getLogger().info("HANDLER     ", "Hotkeys are not supported");
        }
    }

    @Override
    public void applicationStarted() {
    }

    public boolean areHotkeysSupported() {
        return this.supported;
    }

    public static synchronized HotkeyHandler getInstance() {
        if (instance == null) {
            instance = new HotkeyHandler();
        }
        return instance;
    }

    public void disableHotkeys() {
        if (this.areHotkeysSupported() && this.enabled) {
            for (Hotkey hotkey : this.hotkeysConfig) {
                this.hotkeys.unregisterHotkey(hotkey);
            }
            this.hotkeys.deactivate();
            this.enabled = false;
        }
    }

    public void enableHotkeys(HotkeysConfig hotkeysConfig) {
        this.disableHotkeys();
        this.hotkeysConfig = hotkeysConfig == null ? DEFAULT_HOTKEYS_CONFIG : hotkeysConfig;
        this.registerAndActivateHotkeys();
    }

    public HotkeysConfig getDefaultHotkeysConfiguration() {
        HotkeysConfig hotkeysConfig = new HotkeysConfig();
        for (Hotkey hotkey : DEFAULT_HOTKEYS_CONFIG) {
            hotkeysConfig.putHotkey(new Hotkey(hotkey.getId(), hotkey.getMod(), hotkey.getKey(), hotkey.getDescription()));
        }
        return hotkeysConfig;
    }

    private void registerAndActivateHotkeys() {
        if (this.areHotkeysSupported()) {
            boolean bl = true;
            for (Hotkey hotkey : this.hotkeysConfig) {
                if (this.hotkeys.registerHotkey(hotkey)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.hotkeys.activate();
                this.enabled = true;
                HotkeyHandler.getLogger().info("HOTKEYS     ", "Hotkeys activated successfully");
            } else {
                for (Hotkey hotkey : this.hotkeysConfig) {
                    this.hotkeys.unregisterHotkey(hotkey);
                }
                ApplicationState.getInstance().setEnableHotkeys(false);
                GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("HOTKEYS_ACTIVATION_ERROR_MESSAGE"));
                HotkeyHandler.getLogger().error("HOTKEYS     ", "Hotkeys were not activated successfully");
            }
        }
    }

    @Override
    public void applicationFinish() {
        if (this.areHotkeysSupported()) {
            this.hotkeys.cleanUp();
        }
    }

    public HotkeysConfig getHotkeysConfig() {
        HotkeysConfig hotkeysConfig = new HotkeysConfig();
        for (Hotkey hotkey : this.hotkeysConfig) {
            hotkeysConfig.putHotkey(new Hotkey(hotkey.getId(), hotkey.getMod(), hotkey.getKey(), hotkey.getDescription()));
        }
        return hotkeysConfig;
    }

    @Override
    public void onHotKey(int n) {
        HotkeyHandler.getLogger().debug("HANDLER     ", "Hotkey ", n);
        switch (n) {
            case 1: {
                PlayerHandler.getInstance().playNextAudioObject();
                break;
            }
            case 2: {
                PlayerHandler.getInstance().playPreviousAudioObject();
                break;
            }
            case 3: {
                PlayerHandler.getInstance().volumeUp();
                break;
            }
            case 4: {
                PlayerHandler.getInstance().volumeDown();
                break;
            }
            case 5: {
                PlayerHandler.getInstance().playCurrentAudioObject(true);
                break;
            }
            case 6: {
                PlayerHandler.getInstance().stopCurrentAudioObject(true);
                break;
            }
            case 7: {
                GuiHandler.getInstance().toggleWindowVisibility();
                break;
            }
            case 8: {
                Actions.getAction(MuteAction.class).actionPerformed(null);
                break;
            }
            case 9: {
                NotifyHandler.getInstance().showNotification(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList());
                break;
            }
            default: {
                HotkeyHandler.getLogger().error("HOTKEYS     ", StringUtils.getString("Unknown hotkey id: ", n));
            }
        }
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        if (applicationState.isEnableHotkeys()) {
            this.enableHotkeys(applicationState.getHotkeysConfig());
        } else {
            this.disableHotkeys();
        }
    }

    static {
        DEFAULT_HOTKEYS_CONFIG = new HotkeysConfig();
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(1, 640, 39, I18nUtils.getString("NEXT")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(2, 640, 37, I18nUtils.getString("PREVIOUS")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(3, 640, 38, I18nUtils.getString("VOLUME_UP")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(4, 640, 40, I18nUtils.getString("VOLUME_DOWN")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(5, 640, 80, I18nUtils.getString("PAUSE")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(6, 640, 83, I18nUtils.getString("STOP")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(7, 640, 87, I18nUtils.getString("TOGGLE_WINDOW_VISIBILITY")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(8, 640, 77, I18nUtils.getString("MUTE")));
        DEFAULT_HOTKEYS_CONFIG.putHotkey(new Hotkey(9, 640, 73, I18nUtils.getString("SHOW_OSD")));
    }
}

