/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.hotkeys;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.ConstructorProperties;

public class Hotkey {
    private int id;
    private int mod;
    private int key;
    private String description;

    @ConstructorProperties(value={"id", "mod", "key", "description"})
    public Hotkey(int n, int n2, int n3, String string) {
        this.id = n;
        this.mod = n2;
        this.key = n3;
        this.description = string;
    }

    public int getId() {
        return this.id;
    }

    public int getMod() {
        return this.mod;
    }

    public int getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMod(int n) {
        this.mod = n;
    }

    public void setKey(int n) {
        this.key = n;
    }

    public String getKeyDescription() {
        String string = KeyEvent.getKeyText(this.getKey());
        if (this.getMod() != 0) {
            String string2 = InputEvent.getModifiersExText(this.getMod());
            if (string.equals(string2)) {
                return string;
            }
            return string2 + "+" + string;
        }
        return string;
    }

    public boolean isRecommended() {
        boolean bl = false;
        if (this.getMod() != 0 && this.getKey() != 0 && !this.isKeyModifier(this.getKey())) {
            bl = true;
        } else if (this.isFKey(this.getKey())) {
            bl = true;
        }
        return bl;
    }

    private boolean isFKey(int n) {
        return n == 112 || n == 113 || n == 114 || n == 115 || n == 116 || n == 117 || n == 118 || n == 119 || n == 120 || n == 121 || n == 122 || n == 123;
    }

    private boolean isKeyModifier(int n) {
        return n == 18 || n == 65406 || n == 17 || n == 157 || n == 16;
    }

    public String toString() {
        return this.description + " " + this.getKeyDescription();
    }
}

