/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.hotkeys;

import java.lang.reflect.Constructor;
import net.sourceforge.atunes.kernel.modules.hotkeys.Hotkey;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyListener;
import net.sourceforge.atunes.kernel.modules.hotkeys.Win32Hotkeys;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;

public abstract class AbstractHotkeys {
    private HotkeyListener hotkeyListener;

    protected AbstractHotkeys(HotkeyListener hotkeyListener) {
        this.hotkeyListener = hotkeyListener;
    }

    public abstract boolean registerHotkey(Hotkey var1);

    public abstract void unregisterHotkey(Hotkey var1);

    public abstract void deactivate();

    public abstract void activate();

    public abstract void cleanUp();

    public static AbstractHotkeys createInstance(HotkeyListener hotkeyListener) {
        try {
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS && !SystemProperties.OS.is64Bit() && Win32Hotkeys.isSupported()) {
                Class<?> clazz = Class.forName("net.sourceforge.atunes.kernel.modules.hotkeys.Win32Hotkeys");
                Constructor<?> constructor = clazz.getConstructor(HotkeyListener.class);
                return (AbstractHotkeys)constructor.newInstance(hotkeyListener);
            }
            if (SystemProperties.OS == SystemProperties.OperatingSystem.LINUX) {
                Class<?> clazz = Class.forName("net.sourceforge.atunes.kernel.modules.hotkeys.X11Hotkeys");
                Constructor<?> constructor = clazz.getConstructor(HotkeyListener.class);
                return (AbstractHotkeys)constructor.newInstance(hotkeyListener);
            }
            return null;
        }
        catch (Throwable throwable) {
            new Logger().info("HOTKEYS     ", "No hotkeys supported");
            return null;
        }
    }

    protected HotkeyListener getHotkeyListener() {
        return this.hotkeyListener;
    }
}

