/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.draganddrop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.draganddrop.PlayListDragableRow;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryLoader;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;

public class PlayListTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 4366983690375897364L;
    private static Logger logger;
    private static DataFlavor internalDataFlavor;
    private static final String URI_LIST_MIME_TYPE = "text/uri-list;class=java.lang.String";
    private static DataFlavor uriListFlavor;

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.getTransferable().isDataFlavorSupported(internalDataFlavor)) {
            try {
                List list = (List)transferSupport.getTransferable().getTransferData(internalDataFlavor);
                if (list == null || list.isEmpty()) {
                    return false;
                }
                if (list.get(0) instanceof PlayListDragableRow) {
                    try {
                        ((JTable.DropLocation)transferSupport.getDropLocation()).getRow();
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
                return true;
            }
            catch (Exception exception) {
                PlayListTableTransferHandler.getLogger().error("DESKTOP     ", exception);
                transferSupport.setShowDropLocation(true);
                return true;
            }
        }
        if (PlayListTableTransferHandler.hasFileFlavor(transferSupport.getDataFlavors())) {
            return true;
        }
        return PlayListTableTransferHandler.hasStringFlavor(transferSupport.getDataFlavors());
    }

    private static boolean hasFileFlavor(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStringFlavor(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasURIListFlavor(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!uriListFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        if (transferSupport.getTransferable().isDataFlavorSupported(internalDataFlavor)) {
            return PlayListTableTransferHandler.processInternalImport(transferSupport);
        }
        return PlayListTableTransferHandler.processExternalImport(transferSupport);
    }

    private static boolean processInternalImport(TransferHandler.TransferSupport transferSupport) {
        try {
            int n;
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
            List list = (List)transferSupport.getTransferable().getTransferData(internalDataFlavor);
            if (list == null || list.isEmpty()) {
                return false;
            }
            if (list.get(0) instanceof PlayListDragableRow) {
                return PlayListTableTransferHandler.moveRowsInPlayList(list, ((JTable.DropLocation)transferSupport.getDropLocation()).getRow());
            }
            for (n = 0; n < list.size(); ++n) {
                List<AudioObject> list2;
                Object e = list.get(n);
                if (e instanceof DefaultMutableTreeNode) {
                    list2 = ControllerProxy.getInstance().getNavigationController().getAudioObjectsForTreeNode(NavigationHandler.getInstance().getCurrentView().getClass(), (DefaultMutableTreeNode)e);
                    if (list2 == null) continue;
                    arrayList.addAll((Collection<AudioObject>)list2);
                    continue;
                }
                if (!(e instanceof Integer)) continue;
                list2 = (Integer)e;
                arrayList.add(ControllerProxy.getInstance().getNavigationController().getAudioObjectInNavigationTable((Integer)((Object)list2)));
            }
            n = GuiHandler.getInstance().getPlayListTable().rowAtPoint(transferSupport.getDropLocation().getDropPoint());
            if (!arrayList.isEmpty()) {
                AudioObjectComparator.sort(arrayList);
                PlayListHandler.getInstance().addToPlayList(n, arrayList, true);
                if (n == -1) {
                    n = PlayListHandler.getInstance().getCurrentPlayList(true).size() - arrayList.size();
                }
                GuiHandler.getInstance().getPlayListTable().getSelectionModel().addSelectionInterval(n, n + arrayList.size() - 1);
            }
        }
        catch (Exception exception) {
            PlayListTableTransferHandler.getLogger().internalError(exception);
        }
        return false;
    }

    private static boolean moveRowsInPlayList(List<PlayListDragableRow> list, int n) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        final boolean bl = list.get(0).getRowPosition() < n;
        Collections.sort(list, new Comparator<PlayListDragableRow>(){

            @Override
            public int compare(PlayListDragableRow playListDragableRow, PlayListDragableRow playListDragableRow2) {
                return (bl ? -1 : 1) * Integer.valueOf(playListDragableRow.getRowPosition()).compareTo(playListDragableRow2.getRowPosition());
            }
        });
        int n2 = (bl ? list.get(list.size() - 1) : list.get(0)).getRowPosition();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl2 = n == PlayListHandler.getInstance().getCurrentPlayList(true).size() - 1;
        int n3 = 0;
        for (PlayListDragableRow object : list) {
            int n4 = n + (object.getRowPosition() - n2);
            if (bl2) {
                n4 = PlayListHandler.getInstance().getCurrentPlayList(true).size() - (n3 + 1);
            }
            arrayList.add(n4);
            PlayListHandler.getInstance().moveRowTo(object.getRowPosition(), n4);
            ++n3;
        }
        ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        for (Integer n5 : arrayList) {
            GuiHandler.getInstance().getPlayListTable().getSelectionModel().addSelectionInterval(n5, n5);
        }
        return true;
    }

    private static List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
                PlayListTableTransferHandler.getLogger().error("DESKTOP     ", uRISyntaxException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PlayListTableTransferHandler.getLogger().error("DESKTOP     ", illegalArgumentException);
            }
        }
        return arrayList;
    }

    private static boolean processExternalImport(TransferHandler.TransferSupport transferSupport) {
        Object object;
        List<File> list = null;
        try {
            if (PlayListTableTransferHandler.hasFileFlavor(transferSupport.getDataFlavors())) {
                list = (List<File>)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            } else if (PlayListTableTransferHandler.hasURIListFlavor(transferSupport.getDataFlavors())) {
                list = PlayListTableTransferHandler.textURIListToFileList((String)transferSupport.getTransferable().getTransferData(uriListFlavor));
            } else if (PlayListTableTransferHandler.hasStringFlavor(transferSupport.getDataFlavors())) {
                object = (String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor);
                PlayListTableTransferHandler.getLogger().info("DESKTOP     ", object);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            PlayListTableTransferHandler.getLogger().error("DESKTOP     ", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            PlayListTableTransferHandler.getLogger().error("DESKTOP     ", iOException);
        }
        if (list != null && !list.isEmpty()) {
            object = new ArrayList();
            for (File file : list) {
                if (file.isDirectory()) {
                    object.addAll(RepositoryLoader.getSongsForFolder(file, null));
                    continue;
                }
                if (AudioFile.isValidAudioFile(file)) {
                    AudioFile audioFile = new AudioFile(file);
                    object.add(audioFile);
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith("m3u")) continue;
                object.addAll(PlayListIO.getFilesFromList(file));
            }
            int n = GuiHandler.getInstance().getPlayListTable().rowAtPoint(transferSupport.getDropLocation().getDropPoint());
            if (!object.isEmpty()) {
                AudioObjectComparator.sort((List<AudioObject>)object);
                PlayListHandler.getInstance().addToPlayList(n, (List<? extends AudioObject>)object, true);
                if (n == -1) {
                    n = PlayListHandler.getInstance().getCurrentPlayList(true).size() - object.size();
                }
                GuiHandler.getInstance().getPlayListTable().getSelectionModel().addSelectionInterval(n, n + object.size() - 1);
            }
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    static {
        try {
            internalDataFlavor = new DataFlavor("aTunes/objects; class=java.io.InputStream");
            uriListFlavor = new DataFlavor(URI_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            PlayListTableTransferHandler.getLogger().error("DESKTOP     ", classNotFoundException);
        }
    }
}

