/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.youtube;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeResultEntry;
import net.sourceforge.atunes.utils.I18nUtils;

public class YoutubeResultTableModel
implements TableModel {
    private List<YoutubeResultEntry> entries;
    private List<TableModelListener> listeners;

    public YoutubeResultTableModel(List<YoutubeResultEntry> list) {
        this.entries = list;
        this.listeners = new ArrayList<TableModelListener>();
    }

    public void addEntries(List<YoutubeResultEntry> list) {
        this.entries.addAll(list);
        this.refresh();
    }

    public void clearEntries() {
        this.entries.clear();
        this.refresh();
    }

    public YoutubeResultEntry getEntry(int n) {
        return this.entries.get(n);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return YoutubeResultEntry.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        return I18nUtils.getString("YOUTUBE_VIDEOS");
    }

    @Override
    public int getRowCount() {
        return this.entries != null ? this.entries.size() : 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.entries.get(n);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    private void refresh() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, -1, -1, -1, 0);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(tableModelEvent);
        }
    }
}

