/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.audioobject;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.atunes.gui.views.controls.CustomTextPane;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.EditTagAction;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.audioobject.LyricsDataSource;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsService;
import net.sourceforge.atunes.misc.ClipboardFacade;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class LyricsContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = 962229017133714396L;
    private CustomTextPane lyricsContainer;
    private JMenu addLyrics;
    private JMenuItem copyLyrics;
    private JMenuItem openLyrics;
    private String lyricsSourceUrl;
    private AudioObject audioObject;

    public LyricsContent() {
        super(new LyricsDataSource());
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, AudioObject> hashMap = new HashMap<String, AudioObject>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        this.audioObject = audioObject;
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map.containsKey("LYRIC")) {
            Lyrics lyrics = (Lyrics)map.get("LYRIC");
            this.lyricsContainer.setText(lyrics.getLyrics());
            this.lyricsContainer.setCaretPosition(0);
            boolean bl = lyrics != null && !lyrics.getLyrics().trim().isEmpty();
            this.copyLyrics.setEnabled(bl);
            this.addLyrics.setEnabled(!bl);
            this.lyricsSourceUrl = lyrics != null ? lyrics.getUrl() : null;
            this.openLyrics.setEnabled(bl);
            if (!bl) {
                this.addLyrics.removeAll();
                for (Map.Entry<String, String> entry : LyricsService.getInstance().getUrlsForAddingNewLyrics(this.audioObject.getArtist(), this.audioObject.getTitle()).entrySet()) {
                    JMenuItem jMenuItem = new JMenuItem(entry.getKey());
                    jMenuItem.addActionListener(new OpenUrlActionListener(entry));
                    this.addLyrics.add(jMenuItem);
                }
                this.addLyrics.setEnabled(this.addLyrics.getMenuComponentCount() > 0);
            }
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.lyricsContainer.setText(null);
        this.copyLyrics.setEnabled(false);
        this.addLyrics.setEnabled(false);
        this.addLyrics.removeAll();
        this.openLyrics.setEnabled(false);
        this.lyricsSourceUrl = null;
        this.audioObject = null;
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("LYRICS");
    }

    @Override
    protected Component getComponent() {
        this.lyricsContainer = new CustomTextPane(1);
        this.lyricsContainer.setBorder(null);
        this.lyricsContainer.setEditable(false);
        this.lyricsContainer.setOpaque(false);
        return this.lyricsContainer;
    }

    @Override
    protected List<Component> getOptions() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.copyLyrics = new JMenuItem(new AbstractAction(I18nUtils.getString("COPY_TO_CLIPBOARD")){
            private static final long serialVersionUID = -851267486478098295L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = LyricsContent.this.lyricsContainer.getText();
                if (string == null) {
                    string = "";
                }
                ClipboardFacade.copyToClipboard(string);
            }
        });
        arrayList.add(this.copyLyrics);
        this.addLyrics = new JMenu(I18nUtils.getString("ADD_LYRICS"));
        arrayList.add(this.addLyrics);
        this.openLyrics = new JMenuItem(new AbstractAction(I18nUtils.getString("OPEN_LYRICS_SOURCE")){
            private static final long serialVersionUID = 9043861642969889713L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LyricsContent.this.lyricsSourceUrl != null && !LyricsContent.this.lyricsSourceUrl.trim().isEmpty()) {
                    DesktopUtils.openURL(LyricsContent.this.lyricsSourceUrl);
                } else if (LyricsContent.this.audioObject instanceof AudioFile) {
                    ControllerProxy.getInstance().getEditTagDialogController(EditTagAction.EditTagSources.NAVIGATOR).editFiles(Arrays.asList((AudioFile)LyricsContent.this.audioObject));
                }
            }
        });
        arrayList.add(this.openLyrics);
        return arrayList;
    }

    private static final class OpenUrlActionListener
    implements ActionListener {
        private final Map.Entry<String, String> entry;

        private OpenUrlActionListener(Map.Entry<String, String> entry) {
            this.entry = entry;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DesktopUtils.openURL(this.entry.getValue());
        }
    }
}

