/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.model.AudioObject;

public class TimesPlayedColumn
extends AbstractColumn {
    private static final long serialVersionUID = 7879150472122090859L;

    public TimesPlayedColumn() {
        super("TIMES_PLAYED", String.class);
        this.setWidth(100);
        this.setVisible(false);
        this.setAlignment(0);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        AudioFileStats audioFileStats;
        int n = 0;
        int n2 = 0;
        if (audioObject instanceof AudioFile) {
            audioFileStats = StatisticsHandler.getInstance().getAudioFileStatistics((AudioFile)audioObject);
            int n3 = n = audioFileStats != null ? audioFileStats.getTimesPlayed() : 0;
        }
        if (audioObject2 instanceof AudioFile) {
            audioFileStats = StatisticsHandler.getInstance().getAudioFileStatistics((AudioFile)audioObject2);
            n2 = audioFileStats != null ? audioFileStats.getTimesPlayed() : 0;
        }
        return Integer.valueOf(n).compareTo(n2);
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject instanceof Radio) {
            return "";
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return "";
        }
        AudioFileStats audioFileStats = StatisticsHandler.getInstance().getAudioFileStatistics((AudioFile)audioObject);
        if (audioFileStats != null && audioFileStats.getTimesPlayed() > 0) {
            return Integer.toString(audioFileStats.getTimesPlayed());
        }
        return "";
    }
}

