/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class LengthColumn
extends AbstractColumn {
    private static final long serialVersionUID = -4428276519530619107L;

    public LengthColumn() {
        super("DURATION", String.class);
        this.setWidth(100);
        this.setVisible(true);
        this.setAlignment(0);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return Long.valueOf(audioObject.getDuration()).compareTo(Long.valueOf(audioObject2.getDuration()));
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject instanceof Radio) {
            return "";
        }
        if (audioObject instanceof PodcastFeedEntry && ((PodcastFeedEntry)audioObject).getDuration() <= 0) {
            return "-";
        }
        return StringUtils.seconds2String(audioObject.getDuration());
    }
}

