/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class FrequencyColumn
extends AbstractColumn {
    private static final long serialVersionUID = -198950195313638217L;

    public FrequencyColumn() {
        super("FREQUENCY", String.class);
        this.setWidth(100);
        this.setVisible(false);
        this.setAlignment(0);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        return Integer.valueOf(audioObject.getFrequency()).compareTo(audioObject2.getFrequency());
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject.getFrequency() > 0) {
            return StringUtils.getString(Integer.toString(audioObject.getFrequency()), " Hz");
        }
        return "";
    }
}

