/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.misc.log.Logger;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public class ColumnSets
implements PluginListener {
    private static List<AbstractColumnSet> columnSets;
    private static ColumnSets instance;
    private Logger logger;

    public static ColumnSets getInstance() {
        if (instance == null) {
            instance = new ColumnSets();
        }
        return instance;
    }

    private static List<AbstractColumnSet> getColumnSets() {
        if (columnSets == null) {
            columnSets = new ArrayList<AbstractColumnSet>();
        }
        return columnSets;
    }

    protected static void registerColumnSet(AbstractColumnSet abstractColumnSet) {
        ColumnSets.getColumnSets().add(abstractColumnSet);
    }

    public static void storeColumnSettings() {
        for (AbstractColumnSet abstractColumnSet : ColumnSets.getColumnSets()) {
            abstractColumnSet.storeCurrentColumnSettings();
        }
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        try {
            for (AbstractColumnSet abstractColumnSet : ColumnSets.getColumnSets()) {
                abstractColumnSet.addNewColumn((AbstractColumn)PluginsHandler.getInstance().getNewInstance(pluginInfo));
            }
        }
        catch (PluginSystemException pluginSystemException) {
            this.getLogger().error("COLUMNS     ", (Object)pluginSystemException);
        }
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        Class<?> clazz = null;
        Iterator<Object> iterator = collection.iterator();
        if (iterator.hasNext()) {
            Plugin object = iterator.next();
            clazz = object.getClass();
        }
        for (AbstractColumnSet abstractColumnSet : ColumnSets.getColumnSets()) {
            abstractColumnSet.removeColumn(clazz);
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

