/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.encoders;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class LameEncoder
implements Encoder {
    public static final String FORMAT_NAME = "MP3";
    public static final String LAME = "lame";
    public static final String QUALITY = "-b";
    public static final String PRESET = "--preset";
    public static final String TITLE = "--tt";
    public static final String ARTIST = "--ta";
    public static final String ALBUM = "--tl";
    public static final String TRACK = "--tn";
    public static final String VERSION = "--version";
    static final String[] MP3_QUALITIES = new String[]{"insane", "extreme", "medium", "standard", "128", "160", "192", "224", "256", "320"};
    static final String MP3_DEFAULT_QUALITY = "medium";
    private Logger logger;
    private Process p;
    private ProgressListener listener;
    private String albumArtist;
    private String album;
    private int year;
    private String genre;
    private String quality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testTool() {
        boolean bl;
        int n;
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            return true;
        }
        BufferedReader bufferedReader = null;
        try {
            Process process = SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new ProcessBuilder(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, LAME), VERSION).start() : new ProcessBuilder(LAME, VERSION).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (bufferedReader.readLine() != null) {
            }
            n = process.waitFor();
            if (n != 0) {
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(File file, File file2, String string, int n, String string2, String string3) {
        boolean bl;
        this.getLogger().info("LAME ENCODER", StringUtils.getString("Mp3 encoding process started... ", file.getName(), " -> ", file2.getName()));
        BufferedReader bufferedReader = null;
        try {
            int n2;
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, LAME));
            } else {
                arrayList.add(LAME);
            }
            if (this.quality.contains("insane") || this.quality.contains("extreme") || this.quality.contains(MP3_DEFAULT_QUALITY) || this.quality.contains("standard")) {
                arrayList.add(PRESET);
            } else {
                arrayList.add(QUALITY);
            }
            arrayList.add(this.quality);
            arrayList.add(file.getAbsolutePath());
            arrayList.add(file2.getAbsolutePath());
            this.p = new ProcessBuilder(arrayList).start();
            bufferedReader = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            String string4 = null;
            int n4 = -1;
            while ((string4 = bufferedReader.readLine()) != null) {
                if (this.listener == null) continue;
                if (string4.matches(".*\\(..%\\).*")) {
                    n3 = Integer.parseInt(string4.substring(string4.indexOf(40) + 1, string4.indexOf(37)).trim());
                    if (n3 == n4) continue;
                    n2 = n4 = n3;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LameEncoder.this.listener.notifyProgress(n2);
                        }
                    });
                    continue;
                }
                if (!string4.matches(".*\\(100%\\).*") || n4 == 100) continue;
                n4 = 100;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LameEncoder.this.listener.notifyProgress(100);
                    }
                });
            }
            n3 = this.p.waitFor();
            if (n3 != 0) {
                this.getLogger().error("LAME ENCODER", StringUtils.getString("Process returned code ", n3));
                n2 = 0;
                ClosingUtils.close(bufferedReader);
                return n2 != 0;
            }
            try {
                AudioFile audioFile = new AudioFile(file2);
                DefaultTag defaultTag = new DefaultTag();
                defaultTag.setAlbum(this.album);
                defaultTag.setAlbumArtist(this.albumArtist);
                defaultTag.setArtist(string2);
                defaultTag.setYear(this.year);
                defaultTag.setTitle(string);
                defaultTag.setGenre(this.genre);
                defaultTag.setComposer(string3);
                defaultTag.setTrackNumber(n);
                TagModifier.setInfo(audioFile, defaultTag);
            }
            catch (Exception exception) {
                this.getLogger().error("LAME ENCODER", StringUtils.getString("Jaudiotagger: Process execution caused exception ", exception));
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            this.getLogger().info("LAME ENCODER", "Encoded ok!!");
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            this.getLogger().error("LAME ENCODER", StringUtils.getString("Process execution caused exception ", exception));
            boolean bl3 = false;
            return bl3;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    @Override
    public String getExtensionOfEncodedFiles() {
        return "mp3";
    }

    @Override
    public void setAlbum(String string) {
        this.album = string;
    }

    @Override
    public void setArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setGenre(String string) {
        this.genre = string;
    }

    @Override
    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    @Override
    public void setQuality(String string) {
        this.quality = string;
    }

    @Override
    public void setYear(int n) {
        this.year = n;
    }

    @Override
    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    @Override
    public String[] getAvailableQualities() {
        return MP3_QUALITIES;
    }

    @Override
    public String getDefaultQuality() {
        return MP3_DEFAULT_QUALITY;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

