/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.encoders;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class FlacEncoder
implements Encoder {
    public static final String FORMAT_NAME = "FLAC";
    public static final String FLAC = "flac";
    public static final String OUTPUT = "-o";
    public static final String FORCE = "-f";
    public static final String ADD_TAG = "-t";
    public static final String APPEND = "-a";
    public static final String TITLE = "TITLE=";
    public static final String ARTIST = "ARTIST=";
    public static final String ALBUM = "ALBUM=";
    public static final String TRACK = "TRACKNUMBER=";
    public static final String QUALITY = "-q";
    public static final String VERSION = "--version";
    static final String[] FLAC_QUALITY = new String[]{"-0", "-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8"};
    static final String DEFAULT_FLAC_QUALITY = "-5";
    private Logger logger;
    private Process process;
    private ProgressListener listener;
    private String albumArtist;
    private String album;
    private int year;
    private String genre;
    private String quality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean testTool() {
        boolean bl;
        int n;
        BufferedReader bufferedReader = null;
        try {
            Process process = SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new ProcessBuilder(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, FLAC), VERSION).start() : new ProcessBuilder(FLAC, VERSION).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (bufferedReader.readLine() != null) {
            }
            n = process.waitFor();
            if (n != 0) {
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (IOException iOException) {
            n = 0;
            return n != 0;
        }
        catch (InterruptedException interruptedException) {
            n = 0;
            return n != 0;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(File file, File file2, String string, int n, String string2, String string3) {
        boolean bl;
        this.getLogger().info("FLAC ENCODER", StringUtils.getString("Flac encoding process started... ", file.getName(), " -> ", file2.getName()));
        BufferedReader bufferedReader = null;
        try {
            boolean audioFile;
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, FLAC));
            } else {
                arrayList.add(FLAC);
            }
            arrayList.add(this.quality);
            arrayList.add(FORCE);
            arrayList.add(file.getAbsolutePath());
            arrayList.add(OUTPUT);
            arrayList.add(file2.getAbsolutePath());
            this.process = new ProcessBuilder(arrayList).start();
            bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            String string4 = null;
            int bl3 = -1;
            boolean bl2 = false;
            while ((string4 = bufferedReader.readLine()) != null) {
                boolean bl4;
                n2 = string4.indexOf(37);
                if (this.listener == null || !string4.contains("% complete, ratio") || (bl2 = Integer.parseInt(string4.substring(n2 - 2, n2).trim())) == bl4) continue;
                audioFile = bl4 = bl2;
                SwingUtilities.invokeLater(new Runnable(audioFile ? 1 : 0){
                    final /* synthetic */ int val$percentHelp;
                    {
                        this.val$percentHelp = n;
                    }

                    @Override
                    public void run() {
                        FlacEncoder.this.listener.notifyProgress(this.val$percentHelp);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlacEncoder.this.listener.notifyProgress(100);
                }
            });
            n2 = this.process.waitFor();
            if (n2 != 0) {
                this.getLogger().error("FLAC ENCODER", StringUtils.getString("Process returned code ", n2));
                audioFile = false;
                ClosingUtils.close(bufferedReader);
                return audioFile;
            }
            try {
                AudioFile exception = new AudioFile(file2);
                DefaultTag bl5 = new DefaultTag();
                bl5.setAlbum(this.album);
                bl5.setAlbumArtist(this.albumArtist);
                bl5.setArtist(string2);
                bl5.setYear(this.year);
                bl5.setGenre(this.genre);
                bl5.setTitle(string);
                bl5.setComposer(string3);
                bl5.setTrackNumber(n);
                TagModifier.setInfo(exception, bl5);
            }
            catch (Exception bl5) {
                this.getLogger().error("FLAC ENCODER", StringUtils.getString("Jaudiotagger: Process execution caused exception ", bl5));
                boolean bl6 = false;
                ClosingUtils.close(bufferedReader);
                return bl6;
            }
            this.getLogger().info("FLAC ENCODER", "Encoded ok!!");
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (IOException iOException) {
            this.getLogger().error("FLAC ENCODER", StringUtils.getString("Process execution caused exception ", iOException));
            boolean bl6 = false;
            return bl6;
        }
        catch (InterruptedException interruptedException) {
            boolean bl7 = false;
            return bl7;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    @Override
    public String getExtensionOfEncodedFiles() {
        return FLAC;
    }

    @Override
    public void setAlbum(String string) {
        this.album = string;
    }

    @Override
    public void setArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setGenre(String string) {
        this.genre = string;
    }

    @Override
    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    @Override
    public void setQuality(String string) {
        this.quality = string;
    }

    @Override
    public void setYear(int n) {
        this.year = n;
    }

    @Override
    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public String[] getAvailableQualities() {
        return FLAC_QUALITY;
    }

    @Override
    public String getDefaultQuality() {
        return DEFAULT_FLAC_QUALITY;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

