/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.AbstractCdToWavConverter;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Cdparanoia
extends AbstractCdToWavConverter {
    private static final String CDPARANOIA_COMMAND_STRING = "cdparanoia";
    private static final String VERSION = "-V";
    private static final String QUERY = "-Q";
    private static final String WAVFORMAT = "-w";
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean pTestTool() {
        if (SystemProperties.OS != SystemProperties.OperatingSystem.WINDOWS) {
            boolean bl;
            BufferedReader bufferedReader = null;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(CDPARANOIA_COMMAND_STRING, VERSION);
                Process process = processBuilder.start();
                bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while (bufferedReader.readLine() != null) {
                }
                int n = process.waitFor();
                if (n != 0) {
                    boolean bl2 = false;
                    ClosingUtils.close(bufferedReader);
                    return bl2;
                }
                bl = true;
                ClosingUtils.close(bufferedReader);
            }
            catch (IOException iOException) {
                boolean bl3 = false;
                return bl3;
            }
            catch (InterruptedException interruptedException) {
                boolean bl4 = false;
                return bl4;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean cdda2wav(int n, File file) {
        this.getLogger().info("CDPARANOIA  ", StringUtils.getString("Writing wav file for track ", n, " in file ", file.getName()));
        try {
            file.getParentFile().mkdirs();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CDPARANOIA_COMMAND_STRING);
            arrayList.add(WAVFORMAT);
            arrayList.add(String.valueOf(n));
            arrayList.add(file.getAbsolutePath());
            this.getLogger().debugMethodCall("CDPARANOIA  ", arrayList.toArray(new String[arrayList.size()]));
            this.setProcess(new ProcessBuilder(arrayList).start());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Cdparanoia.this.getListener().notifyProgress(-1);
                }
            });
            int n2 = this.getProcess().waitFor();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Cdparanoia.this.getListener().notifyProgress(100);
                }
            });
            if (n2 != 0) {
                this.getLogger().error("CDPARANOIA  ", StringUtils.getString("Process returned code ", n2));
                return false;
            }
            this.getLogger().info("CDPARANOIA  ", "Wav file ok!!");
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.getLogger().error("CDPARANOIA  ", StringUtils.getString("Process execution caused exception ", interruptedException));
            return false;
        }
        catch (IOException iOException) {
            this.getLogger().error("CDPARANOIA  ", StringUtils.getString("Process execution caused exception ", iOException));
            return false;
        }
    }

    @Override
    public boolean cdda2wav(int n, File file, boolean bl) {
        return this.cdda2wav(n, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDInfo retrieveDiscInformation() {
        this.getLogger().info("CDPARANOIA  ", "Getting cd information...");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CDPARANOIA_COMMAND_STRING);
            arrayList.add(QUERY);
            this.getLogger().debugMethodCall("CDPARANOIA  ", arrayList.toArray(new String[arrayList.size()]));
            this.setProcess(new ProcessBuilder(arrayList).start());
            BufferedReader bufferedReader = null;
            boolean bl = false;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.getProcess().getErrorStream(), "ISO8859_1"));
                this.getLogger().info("CDPARANOIA  ", "Trying to read cdparanoia stream");
                String string = null;
                int n = 0;
                String string2 = null;
                String string3 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                ArrayList<String> arrayList5 = new ArrayList<String>();
                int n2 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    this.getLogger().info("CDPARANOIA  ", StringUtils.getString("While loop: ", string));
                    if (string.startsWith("TOTAL")) break;
                    if (string.contains("Table of contents")) {
                        bl = true;
                    }
                    if (bl) {
                        ++n2;
                    }
                    if (n2 <= 3) continue;
                    ++n;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    ArrayList<String> arrayList6 = new ArrayList<String>(8);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList6.add(stringTokenizer.nextToken());
                    }
                    String string4 = (String)arrayList6.get(2);
                    string4 = string4.replace("[", "").replace("]", "");
                    arrayList2.add(string4);
                    arrayList3.add("");
                    arrayList4.add("");
                    arrayList5.add("");
                }
                this.getCdInfo().setTracks(n);
                this.getCdInfo().setDurations(arrayList2);
                this.getCdInfo().setDuration(string2);
                this.getCdInfo().setId(string3);
                this.getCdInfo().setTitles(arrayList3);
                this.getCdInfo().setArtists(arrayList4);
                this.getCdInfo().setComposers(arrayList5);
                ClosingUtils.close(bufferedReader);
            }
            catch (IOException iOException) {
                this.getLogger().error("CDDA2WAV    ", iOException);
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
            this.getLogger().info("CDPARANOIA  ", StringUtils.getString("CD info: ", this.getCdInfo()));
            return this.getCdInfo();
        }
        catch (Exception exception) {
            this.getLogger().error("CDPARANOIA  ", exception);
            return null;
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

