/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav;

import java.io.File;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.Cdda2wav;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.Cdparanoia;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.NoCdListener;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.misc.SystemProperties;

public abstract class AbstractCdToWavConverter {
    private ProgressListener listener;
    private NoCdListener noCdListener;
    private Process process;
    private CDInfo cdInfo = new CDInfo();

    public static AbstractCdToWavConverter createNewConverterForOS() {
        if (SystemProperties.OS == SystemProperties.OperatingSystem.MACOSX) {
            return new Cdparanoia();
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            return new Cdda2wav();
        }
        if (Cdda2wav.pTestTool()) {
            return new Cdda2wav();
        }
        return new Cdparanoia();
    }

    public void notifyNoCd() {
        if (this.noCdListener != null) {
            this.noCdListener.noCd();
        }
    }

    public void stop() {
        this.process.destroy();
    }

    public static boolean testTool() {
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            return Cdda2wav.pTestTool();
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.MACOSX) {
            return Cdparanoia.pTestTool();
        }
        if (Cdda2wav.pTestTool()) {
            return true;
        }
        return Cdparanoia.pTestTool();
    }

    public abstract boolean cdda2wav(int var1, File var2);

    public abstract boolean cdda2wav(int var1, File var2, boolean var3);

    public abstract CDInfo retrieveDiscInformation();

    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public void setNoCdListener(NoCdListener noCdListener) {
        this.noCdListener = noCdListener;
    }

    protected Process getProcess() {
        return this.process;
    }

    protected void setProcess(Process process) {
        this.process = process;
    }

    protected ProgressListener getListener() {
        return this.listener;
    }

    protected CDInfo getCdInfo() {
        return this.cdInfo;
    }

    protected void setCdInfo(CDInfo cDInfo) {
        this.cdInfo = cDInfo;
    }

    protected NoCdListener getNoCdListener() {
        return this.noCdListener;
    }
}

