/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.ripcd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import net.sourceforge.atunes.gui.autocomplete.AutoCompleteDecorator;
import net.sourceforge.atunes.gui.views.dialogs.RipCdDialog;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.ripcd.RipCdDialogListener;
import net.sourceforge.atunes.kernel.modules.cdripper.RipperHandler;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public final class RipCdDialogController
extends AbstractSimpleController<RipCdDialog> {
    public static final String[] FILENAMEPATTERN = new String[]{StringUtils.getString("%N", " - ", "%T"), StringUtils.getString("%A", " - ", "%L", " - ", "%N", " - ", "%T"), StringUtils.getString("%A", " - ", "%T")};
    private boolean folderNameEdited;
    private boolean cancelled;
    private boolean encoderSettingChanged;
    private String artist;
    private String album;
    private int year;
    private String genre;
    private String folder;

    public RipCdDialogController(RipCdDialog ripCdDialog) {
        super(ripCdDialog);
        this.addBindings();
    }

    @Override
    protected void addBindings() {
        List<String> list = Arrays.asList(AbstractTag.genres);
        Collections.sort(list);
        ((RipCdDialog)this.getComponentControlled()).getGenreComboBox().setModel(new ListComboBoxModel(list));
        Map<String, Encoder> map = RipperHandler.getInstance().getAvailableEncoders();
        String[] stringArray = map.keySet().toArray(new String[map.size()]);
        ((RipCdDialog)this.getComponentControlled()).getFormat().setModel(new DefaultComboBoxModel<String>(stringArray));
        AutoCompleteDecorator.decorate(((RipCdDialog)this.getComponentControlled()).getGenreComboBox());
        RipCdDialogListener ripCdDialogListener = new RipCdDialogListener((RipCdDialog)this.getComponentControlled(), this);
        ((RipCdDialog)this.getComponentControlled()).getOk().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getCancel().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getFolderSelectionButton().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getFormat().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getFilePattern().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getFolderName().addKeyListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getTitlesButton().addActionListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getArtistTextField().addKeyListener(ripCdDialogListener);
        ((RipCdDialog)this.getComponentControlled()).getAlbumTextField().addKeyListener(ripCdDialogListener);
    }

    @Override
    protected void addStateBindings() {
    }

    public String getAlbum() {
        return this.album;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getFolder() {
        return FileNameUtils.getValidFolderName(this.folder);
    }

    public String getGenre() {
        return this.genre;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isEncoderSettingChanged() {
        return this.encoderSettingChanged;
    }

    public boolean isFolderNameEdited() {
        return this.folderNameEdited;
    }

    @Override
    protected void notifyReload() {
    }

    public void setAlbum(String string) {
        this.album = string;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public void setEncoderSettingChanged(boolean bl) {
        this.encoderSettingChanged = bl;
    }

    public void setFolder(String string) {
        this.folder = string;
    }

    public void setFolderNameEdited(boolean bl) {
        this.folderNameEdited = bl;
    }

    public void setGenre(String string) {
        this.genre = string;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public void showCdInfo(CDInfo cDInfo, String string) {
        this.setArtist(cDInfo.getArtist());
        ((RipCdDialog)this.getComponentControlled()).getArtistTextField().setText(cDInfo.getArtist());
        this.setAlbum(cDInfo.getAlbum());
        ((RipCdDialog)this.getComponentControlled()).getAlbumTextField().setText(cDInfo.getAlbum());
        this.setYear(DateUtils.getCurrentYear());
        ((RipCdDialog)this.getComponentControlled()).getYearTextField().setText(Integer.toString(DateUtils.getCurrentYear()));
        this.setGenre(((RipCdDialog)this.getComponentControlled()).getGenreComboBox().getSelectedItem().toString());
        if (cDInfo.getArtist() != null && cDInfo.getAlbum() != null) {
            ((RipCdDialog)this.getComponentControlled()).getFolderName().setText(StringUtils.getString(RepositoryHandler.getInstance().getRepositoryPath(), SystemProperties.FILE_SEPARATOR, cDInfo.getArtist(), SystemProperties.FILE_SEPARATOR, cDInfo.getAlbum()));
        } else {
            ((RipCdDialog)this.getComponentControlled()).getFolderName().setText(string);
        }
        ((RipCdDialog)this.getComponentControlled()).getTitlesButton().setEnabled(false);
        ((RipCdDialog)this.getComponentControlled()).getFormat().setSelectedItem(RipperHandler.getInstance().getEncoder());
        ((RipCdDialog)this.getComponentControlled()).getQualityComboBox().setSelectedItem(RipperHandler.getInstance().getEncoderQuality());
        ((RipCdDialog)this.getComponentControlled()).getUseCdErrorCorrection().setSelected(RipperHandler.getInstance().getCdErrorCorrection());
        ((RipCdDialog)this.getComponentControlled()).getFilePattern().setSelectedItem(RipperHandler.getInstance().getFileNamePattern());
        this.setFolder(null);
        ((RipCdDialog)this.getComponentControlled()).setTableData(cDInfo);
        ((RipCdDialog)this.getComponentControlled()).updateTrackNames(cDInfo.getTitles());
        ((RipCdDialog)this.getComponentControlled()).updateArtistNames(cDInfo);
        ((RipCdDialog)this.getComponentControlled()).updateComposerNames(cDInfo.getComposers());
        ((RipCdDialog)this.getComponentControlled()).setVisible(true);
    }
}

