/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.navigation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;

public final class NavigationTreeToolTipListener
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    private NavigationController controller;

    public NavigationTreeToolTipListener(NavigationController navigationController) {
        this.controller = navigationController;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!ApplicationState.getInstance().isShowExtendedTooltip()) {
            return;
        }
        this.controller.setCurrentExtendedToolTipContent(null);
        this.controller.getExtendedToolTip().setVisible(false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!ApplicationState.getInstance().isShowExtendedTooltip()) {
            return;
        }
        TreePath treePath = NavigationHandler.getInstance().getCurrentView().getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object.equals(this.controller.getCurrentExtendedToolTipContent())) {
                return;
            }
            if (ExtendedToolTip.canObjectBeShownInExtendedToolTip(object)) {
                if (!this.controller.getExtendedToolTip().isVisible() || this.controller.getCurrentExtendedToolTipContent() == null || this.controller.getCurrentExtendedToolTipContent() != object) {
                    if (this.controller.getExtendedToolTip().isVisible()) {
                        this.controller.getExtendedToolTip().setVisible(false);
                    }
                    this.controller.getExtendedToolTip().setLocation((int)NavigationHandler.getInstance().getCurrentView().getTree().getLocationOnScreen().getX() + mouseEvent.getX(), (int)NavigationHandler.getInstance().getCurrentView().getTree().getLocationOnScreen().getY() + mouseEvent.getY() + 20);
                    this.controller.getExtendedToolTip().setToolTipContent(object);
                    this.controller.setCurrentExtendedToolTipContent(object);
                } else {
                    this.controller.setCurrentExtendedToolTipContent(null);
                }
                this.controller.getToolTipTimer().setInitialDelay(ApplicationState.getInstance().getExtendedTooltipDelay() * 1000);
                this.controller.getToolTipTimer().setRepeats(false);
                this.controller.getToolTipTimer().start();
            } else {
                this.controller.setCurrentExtendedToolTipContent(null);
                this.controller.getExtendedToolTip().setVisible(false);
                this.controller.getToolTipTimer().stop();
            }
        } else {
            this.controller.setCurrentExtendedToolTipContent(null);
            this.controller.getExtendedToolTip().setVisible(false);
            this.controller.getToolTipTimer().stop();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!ApplicationState.getInstance().isShowExtendedTooltip()) {
            return;
        }
        this.controller.setCurrentExtendedToolTipContent(null);
        this.controller.getExtendedToolTip().setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (!ApplicationState.getInstance().isShowExtendedTooltip()) {
            return;
        }
        this.controller.setCurrentExtendedToolTipContent(null);
        this.controller.getExtendedToolTip().setVisible(false);
    }
}

