/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.audioObjectProperties;

import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.panels.AudioObjectPropertiesPanel;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListEventListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.GenericImageSize;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public final class AudioObjectPropertiesController
extends AbstractSimpleController<AudioObjectPropertiesPanel>
implements PlayListEventListener {
    private AudioObject currentAudioObject;

    public AudioObjectPropertiesController(AudioObjectPropertiesPanel audioObjectPropertiesPanel) {
        super(audioObjectPropertiesPanel);
        this.addBindings();
        this.addStateBindings();
        PlayListHandler.getInstance().addPlayListEventListener(this);
    }

    @Override
    protected void addBindings() {
        ((AudioObjectPropertiesPanel)this.getComponentControlled()).getPictureLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GuiHandler.getInstance().showImageDialog(AudioObjectPropertiesController.this.currentAudioObject);
            }
        });
    }

    @Override
    protected void addStateBindings() {
    }

    public void clearPanel() {
        this.currentAudioObject = null;
        ((AudioObjectPropertiesPanel)this.getComponentControlled()).getPictureLabel().setIcon(null);
        ((AudioObjectPropertiesPanel)this.getComponentControlled()).getPictureLabel().setVisible(false);
        ((AudioObjectPropertiesPanel)this.getComponentControlled()).getMainPanel().setVisible(false);
    }

    void fillFileProperties() {
        if (this.currentAudioObject != null) {
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getBitrateLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("BITRATE"), ":</b>    ", this.currentAudioObject.getBitrate(), " Kbps"));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getFrequencyLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("FREQUENCY"), ":</b>    ", this.currentAudioObject.getFrequency(), " Hz"));
        } else {
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getBitrateLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("BITRATE"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getFrequencyLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("FREQUENCY"), ":</b>    "));
        }
    }

    void fillPicture() {
        if (this.currentAudioObject != null) {
            new FillPictureSwingWorker().execute();
        }
    }

    @Override
    protected Logger getLogger() {
        return super.getLogger();
    }

    void fillSongProperties() {
        if (this.currentAudioObject != null) {
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getUrlLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("FILE"), ":</b>    ", "\u202d", this.currentAudioObject.getUrl(), " \u202c </html>"));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTitleLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("SONG"), ":</b>    ", this.currentAudioObject.getTitleOrFileName(), " - ", this.currentAudioObject.getArtist(), " - ", this.currentAudioObject.getAlbum(), "\u202d (", StringUtils.seconds2String(this.currentAudioObject.getDuration()), ") \u202c </html>"));
            if (this.currentAudioObject.getTrackNumber() > 0) {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTrackLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("TRACK"), ":</b>    ", this.currentAudioObject.getTrackNumber()));
            } else {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTrackLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("TRACK"), ":"));
            }
            if (this.currentAudioObject.getDate() != null) {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getYearLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("DATE"), ":</b>    ", DateFormat.getDateInstance().format(this.currentAudioObject.getDate())));
            } else if (!this.currentAudioObject.getYear().isEmpty()) {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getYearLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("YEAR"), ":</b>    ", this.currentAudioObject.getYear()));
            } else {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getYearLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("YEAR"), ":"));
            }
            if (this.currentAudioObject.getDiscNumber() > 0) {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getDiscNumberLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("DISC_NUMBER"), ":</b>    ", this.currentAudioObject.getDiscNumber()));
            } else {
                ((AudioObjectPropertiesPanel)this.getComponentControlled()).getDiscNumberLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("DISC_NUMBER"), ":"));
            }
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getGenreLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("GENRE"), ":</b>    ", this.currentAudioObject.getGenre()));
            this.refreshFavoriteIcons();
        } else {
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getUrlLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("FILE"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTitleLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("SONG"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTrackLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("TRACK"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getYearLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("YEAR"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getGenreLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("GENRE"), ":</b>    "));
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getDiscNumberLabel().setText(StringUtils.getString("<html><b>", I18nUtils.getString("DISC_NUMBER"), ":</b>    "));
        }
    }

    @Override
    protected void notifyReload() {
    }

    public void onlyShowPropertiesPanel() {
        this.currentAudioObject = null;
        this.fillSongProperties();
        this.fillFileProperties();
        this.fillPicture();
        ((AudioObjectPropertiesPanel)this.getComponentControlled()).getMainPanel().setVisible(true);
    }

    public void refreshFavoriteIcons() {
        if (this.currentAudioObject != null) {
            boolean bl = FavoritesHandler.getInstance().getFavoriteSongsInfo().containsValue(this.currentAudioObject) || FavoritesHandler.getInstance().getFavoriteArtistsInfo().containsKey(this.currentAudioObject.getArtist()) || FavoritesHandler.getInstance().getFavoriteAlbumsInfo().containsKey(this.currentAudioObject.getAlbum());
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getTitleLabel().setIcon(bl ? Images.getImage("favorite.png") : null);
        }
    }

    public void refreshPicture() {
        this.fillPicture();
    }

    public void updateValues(final AudioObject audioObject) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AudioObjectPropertiesController.this.updateValuesEDT(audioObject);
                }
            });
        } else {
            this.updateValuesEDT(audioObject);
        }
    }

    private void updateValuesEDT(AudioObject audioObject) {
        if (audioObject != null) {
            this.getLogger().debug("CONTROLLER  ", audioObject.getUrl());
            this.currentAudioObject = audioObject;
            this.fillSongProperties();
            this.fillFileProperties();
            this.fillPicture();
            ((AudioObjectPropertiesPanel)this.getComponentControlled()).getMainPanel().setVisible(true);
        } else {
            this.clearPanel();
        }
    }

    @Override
    public void clear() {
        if (ApplicationState.getInstance().isStopPlayerOnPlayListClear() && ApplicationState.getInstance().isShowAudioObjectProperties()) {
            this.clearPanel();
        }
    }

    @Override
    public void selectedAudioObjectChanged(AudioObject audioObject) {
        if (ApplicationState.getInstance().isShowAudioObjectProperties()) {
            this.updateValues(audioObject);
        }
    }

    private final class FillPictureSwingWorker
    extends SwingWorker<ImageIcon, Void> {
        private boolean shadowBorder;

        private FillPictureSwingWorker() {
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            ImageIcon imageIcon = AudioObjectPropertiesController.this.currentAudioObject.getImage(ImageSize.SIZE_90);
            if (imageIcon == null) {
                imageIcon = AudioObjectPropertiesController.this.currentAudioObject.getGenericImage(GenericImageSize.MEDIUM);
            }
            this.shadowBorder = AudioObjectPropertiesController.this.currentAudioObject instanceof AudioFile;
            return imageIcon;
        }

        @Override
        protected void done() {
            try {
                ImageIcon imageIcon = (ImageIcon)this.get();
                if (this.shadowBorder) {
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setBorder((Border)new DropShadowBorder());
                } else {
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setBorder(BorderFactory.createEmptyBorder());
                }
                if (imageIcon != null) {
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setIcon(imageIcon);
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setVisible(true);
                } else {
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setIcon(null);
                    ((AudioObjectPropertiesPanel)AudioObjectPropertiesController.this.getComponentControlled()).getPictureLabel().setVisible(false);
                }
            }
            catch (InterruptedException interruptedException) {
                AudioObjectPropertiesController.this.getLogger().internalError(interruptedException);
            }
            catch (ExecutionException executionException) {
                AudioObjectPropertiesController.this.getLogger().internalError(executionException);
            }
        }
    }
}

