/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class SetFavoriteAlbumFromNavigatorAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = 836910667009804037L;

    SetFavoriteAlbumFromNavigatorAction() {
        super(I18nUtils.getString("SET_FAVORITE_ALBUM"), Images.getImage("favorite.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("SET_FAVORITE_ALBUM"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        FavoritesHandler.getInstance().addFavoriteAlbums(list);
        ControllerProxy.getInstance().getNavigationController().refreshTable();
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            return false;
        }
        if (ApplicationState.getInstance().getViewMode() == NavigationController.ViewMode.FOLDER) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Album) continue;
            return false;
        }
        return true;
    }
}

