/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class RemoveRadioAction
extends AbstractActionOverSelectedObjects<Radio> {
    private static final long serialVersionUID = 8755385947718573969L;

    RemoveRadioAction() {
        super(I18nUtils.getString("REMOVE_RADIO"), Images.getImage("delete.png"), Radio.class);
        this.putValue("ShortDescription", I18nUtils.getString("REMOVE_RADIO"));
    }

    @Override
    protected void performAction(List<Radio> list) {
        RadioHandler.getInstance().removeRadios(list);
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (bl) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Radio) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return true;
    }
}

