/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class MarkPodcastEntryListenedAction
extends AbstractActionOverSelectedObjects<PodcastFeedEntry> {
    private static final long serialVersionUID = 1563803489549692850L;

    MarkPodcastEntryListenedAction() {
        super(I18nUtils.getString("MARK_PODCAST_ENTRY_AS_LISTENED"), Images.getImage("markAsRead.png"), PodcastFeedEntry.class);
        this.putValue("ShortDescription", I18nUtils.getString("MARK_PODCAST_ENTRY_AS_LISTENED"));
    }

    @Override
    protected void performAction(List<PodcastFeedEntry> list) {
        for (PodcastFeedEntry podcastFeedEntry : list) {
            podcastFeedEntry.setListened(true);
        }
        ControllerProxy.getInstance().getNavigationController().refreshTable();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        for (AudioObject audioObject : list) {
            if (audioObject instanceof PodcastFeedEntry && !((PodcastFeedEntry)audioObject).isListened()) continue;
            return false;
        }
        return true;
    }
}

