/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.utils.I18nUtils;

public class EditTitlesAction
extends AbstractAction {
    private static final long serialVersionUID = -2883223880879440970L;

    EditTitlesAction() {
        super(I18nUtils.getString("EDIT_TITLES"), Images.getImage("editAlbum.png"));
        this.putValue("ShortDescription", I18nUtils.getString("EDIT_TITLES"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getCurrentView().getTree().getSelectionPath();
        Album album = (Album)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        ControllerProxy.getInstance().getEditTitlesDialogController().editFiles(album);
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Album) continue;
            return false;
        }
        return true;
    }
}

