/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class AddLovedSongInLastFMAction
extends AbstractAction {
    private static final long serialVersionUID = -2687851398606488392L;

    AddLovedSongInLastFMAction() {
        super(I18nUtils.getString("ADD_LOVED_SONG_IN_LASTFM"));
        this.putValue("ShortDescription", I18nUtils.getString("ADD_LOVED_SONG_IN_LASTFM"));
        this.setEnabled(ApplicationState.getInstance().isLastFmEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.loveSong(ContextHandler.getInstance().getCurrentAudioObject());
    }

    public void loveSong(final AudioObject audioObject) {
        this.setEnabled(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                LastFmService.getInstance().addLovedSong(audioObject);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                finally {
                    AddLovedSongInLastFMAction.this.setEnabled(true);
                }
            }
        }.execute();
    }
}

