/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.menus;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.menus.EditTagMenu;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.AddAlbumsMostPlayedAction;
import net.sourceforge.atunes.kernel.actions.AddArtistsMostPlayedAction;
import net.sourceforge.atunes.kernel.actions.AddRandomSongsAction;
import net.sourceforge.atunes.kernel.actions.AddSongsMostPlayedAction;
import net.sourceforge.atunes.kernel.actions.AddUnplayedSongsAction;
import net.sourceforge.atunes.kernel.actions.ClearPlayListAction;
import net.sourceforge.atunes.kernel.actions.CreatePlayListWithSelectedAlbumsAction;
import net.sourceforge.atunes.kernel.actions.CreatePlayListWithSelectedArtistsAction;
import net.sourceforge.atunes.kernel.actions.LoadPlayListAction;
import net.sourceforge.atunes.kernel.actions.MoveDownAction;
import net.sourceforge.atunes.kernel.actions.MoveToBottomAction;
import net.sourceforge.atunes.kernel.actions.MoveToTopAction;
import net.sourceforge.atunes.kernel.actions.MoveUpAction;
import net.sourceforge.atunes.kernel.actions.OpenFolderAction;
import net.sourceforge.atunes.kernel.actions.PlayAction;
import net.sourceforge.atunes.kernel.actions.RemoveFromPlayListAction;
import net.sourceforge.atunes.kernel.actions.SavePlayListAction;
import net.sourceforge.atunes.kernel.actions.SetPlayListSelectionAsFavoriteAlbumAction;
import net.sourceforge.atunes.kernel.actions.SetPlayListSelectionAsFavoriteArtistAction;
import net.sourceforge.atunes.kernel.actions.SetPlayListSelectionAsFavoriteSongAction;
import net.sourceforge.atunes.kernel.actions.ShowPlayListItemInfoAction;
import net.sourceforge.atunes.kernel.actions.ShufflePlayListAction;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PlayListMenu {
    private PlayListMenu() {
    }

    public static void fillPopUpMenu(JPopupMenu jPopupMenu, PlayListTable playListTable) {
        List<Object> list = PlayListMenu.getComponents(playListTable);
        for (Object object : list) {
            if (object instanceof Action) {
                jPopupMenu.add((Action)object);
                continue;
            }
            jPopupMenu.add((Component)object);
        }
    }

    public static void fillMenu(JMenu jMenu, PlayListTable playListTable) {
        List<Object> list = PlayListMenu.getComponents(playListTable);
        for (Object object : list) {
            if (object instanceof Action) {
                jMenu.add((Action)object);
                continue;
            }
            jMenu.add((Component)object);
        }
    }

    private static List<Object> getComponents(PlayListTable playListTable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Actions.getAction(PlayAction.class));
        arrayList.add(Actions.getAction(ShowPlayListItemInfoAction.class));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getMenuItemForAction(OpenFolderAction.class, playListTable));
        arrayList.add(new JSeparator());
        arrayList.add(new EditTagMenu(true, playListTable));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getAction(SavePlayListAction.class));
        arrayList.add(Actions.getAction(LoadPlayListAction.class));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getAction(RemoveFromPlayListAction.class));
        arrayList.add(Actions.getAction(ClearPlayListAction.class));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getAction(MoveToTopAction.class));
        arrayList.add(Actions.getAction(MoveUpAction.class));
        arrayList.add(Actions.getAction(MoveDownAction.class));
        arrayList.add(Actions.getAction(MoveToBottomAction.class));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getAction(ShufflePlayListAction.class));
        arrayList.add(new JSeparator());
        JMenu jMenu = new JMenu(I18nUtils.getString("SMART_PLAYLIST"));
        jMenu.add(Actions.getAction(AddRandomSongsAction.class, "ADD_10_RANDOM_SONGS"));
        jMenu.add(Actions.getAction(AddRandomSongsAction.class, "ADD_50_RANDOM_SONGS"));
        jMenu.add(Actions.getAction(AddRandomSongsAction.class, "ADD_100_RANDOM_SONGS"));
        jMenu.add(new JSeparator());
        jMenu.add(Actions.getAction(AddSongsMostPlayedAction.class, "ADD_10_SONGS_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddSongsMostPlayedAction.class, "ADD_50_SONGS_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddSongsMostPlayedAction.class, "ADD_100_SONGS_MOST_PLAYED"));
        jMenu.add(new JSeparator());
        jMenu.add(Actions.getAction(AddAlbumsMostPlayedAction.class, "ADD_ALBUM_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddAlbumsMostPlayedAction.class, "ADD_5_ALBUMS_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddAlbumsMostPlayedAction.class, "ADD_10_ALBUMS_MOST_PLAYED"));
        jMenu.add(new JSeparator());
        jMenu.add(Actions.getAction(AddArtistsMostPlayedAction.class, "ADD_ARTIST_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddArtistsMostPlayedAction.class, "ADD_5_ARTISTS_MOST_PLAYED"));
        jMenu.add(Actions.getAction(AddArtistsMostPlayedAction.class, "ADD_10_ARTISTS_MOST_PLAYED"));
        jMenu.add(new JSeparator());
        jMenu.add(Actions.getAction(AddUnplayedSongsAction.class, "ADD_10_UNPLAYED_SONGS"));
        jMenu.add(Actions.getAction(AddUnplayedSongsAction.class, "ADD_50_UNPLAYED_SONGS"));
        jMenu.add(Actions.getAction(AddUnplayedSongsAction.class, "ADD_100_UNPLAYED_SONGS"));
        arrayList.add(jMenu);
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getAction(SetPlayListSelectionAsFavoriteSongAction.class));
        arrayList.add(Actions.getAction(SetPlayListSelectionAsFavoriteAlbumAction.class));
        arrayList.add(Actions.getAction(SetPlayListSelectionAsFavoriteArtistAction.class));
        arrayList.add(new JSeparator());
        arrayList.add(Actions.getMenuItemForAction(CreatePlayListWithSelectedArtistsAction.class, playListTable));
        arrayList.add(Actions.getMenuItemForAction(CreatePlayListWithSelectedAlbumsAction.class, playListTable));
        return arrayList;
    }

    public static void updatePlayListMenuItems(PlayListTable playListTable) {
        PlayListMenu.updatePlayListPopupMenuItems(playListTable.getMenu(), PlayListHandler.getInstance().getSelectedAudioObjects());
    }

    private static void updatePlayListPopupMenuItems(JPopupMenu jPopupMenu, List<AudioObject> list) {
        for (Component component : jPopupMenu.getComponents()) {
            Action action = null;
            if (component instanceof JMenuItem) {
                action = ((JMenuItem)component).getAction();
            }
            if (component instanceof JMenu) {
                PlayListMenu.updatePlayListMenuItems((JMenu)component, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl = ((AbstractAction)action).isEnabledForPlayListSelection(list);
            action.setEnabled(bl);
        }
    }

    private static void updatePlayListMenuItems(JMenu jMenu, List<AudioObject> list) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            Action action = jMenuItem.getAction();
            if (jMenuItem instanceof JMenu) {
                PlayListMenu.updatePlayListMenuItems((JMenu)jMenuItem, list);
            }
            if (!(action instanceof AbstractAction)) continue;
            boolean bl = ((AbstractAction)action).isEnabledForPlayListSelection(list);
            action.setEnabled(bl);
        }
    }
}

