/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PlayListPrefPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7814272907267661918L;
    public static final String PROP_PLAYLIST_STOP_ON_SWITCH = "PLAYLIST_STOP_ON_SWITCH";
    public static final String PROP_PLAYLIST_STOP_ON_CLEAR = "PLAYLIST_STOP_ON_CLEAR";
    public static final String PROP_AUTO_SCROLL_PLAYLIST = "AUTO_SCROLL_PLAYLIST";
    private JCheckBox stopSongWhenSwitching = new JCheckBox(I18nUtils.getString("PLAYLIST_STOP_ON_SWITCH"));
    private JCheckBox stopSongWhenClearing = new JCheckBox(I18nUtils.getString("PLAYLIST_STOP_ON_CLEAR"));
    private JCheckBox autoScrollPlayList = new JCheckBox(I18nUtils.getString("AUTO_SCROLL_PLAYLIST"));

    public PlayListPrefPanel() {
        super(I18nUtils.getString("PLAYLIST"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.stopSongWhenSwitching, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.stopSongWhenClearing, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.autoScrollPlayList, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setStopPlayerOnPlayListSwitch(this.stopSongWhenSwitching.isSelected());
        applicationState.setStopPlayerOnPlayListClear(this.stopSongWhenClearing.isSelected());
        applicationState.setAutoScrollPlayListEnabled(this.autoScrollPlayList.isSelected());
        return false;
    }

    private void setStopSongWhenSwitching(boolean bl) {
        this.stopSongWhenSwitching.setSelected(bl);
    }

    private void setStopSongWhenClearing(boolean bl) {
        this.stopSongWhenClearing.setSelected(bl);
    }

    private void setAutoScrollPlayList(boolean bl) {
        this.autoScrollPlayList.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setStopSongWhenSwitching(applicationState.isStopPlayerOnPlayListSwitch());
        this.setStopSongWhenClearing(applicationState.isStopPlayerOnPlayListClear());
        this.setAutoScrollPlayList(applicationState.isAutoScrollPlayListEnabled());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("playlist.png");
    }
}

