/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class RipperProgressDialog
extends CustomFrame {
    private static final long serialVersionUID = -3891515847607545757L;
    private JLabel cover;
    private JProgressBar totalProgressBar;
    private JLabel totalProgressValueLabel;
    private JProgressBar decodeProgressBar;
    private JLabel decodeProgressValueLabel;
    private JProgressBar encodeProgressBar;
    private JLabel encodeProgressValueLabel;
    private JButton cancelButton;

    public RipperProgressDialog(Component component) {
        super(I18nUtils.getString("RIPPING_CD"), 420, 200, component);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
    }

    public static void main(String[] stringArray) {
        new RipperProgressDialog(null).setVisible(true);
    }

    public void addCancelAction(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void setArtistAndAlbum(String string, String string2) {
        this.setTitle(StringUtils.getString(I18nUtils.getString("RIPPING_CD"), " ", string, " - ", string2));
    }

    private void setContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.cover = new JLabel(Images.getImage("cdAudio.png"));
        JLabel jLabel = new JLabel(I18nUtils.getString("TOTAL_PROGRESS"));
        this.totalProgressBar = new JProgressBar();
        this.totalProgressBar.setPreferredSize(new Dimension(10, 12));
        this.totalProgressValueLabel = new JLabel();
        JLabel jLabel2 = new JLabel(I18nUtils.getString("DECODING"));
        this.decodeProgressBar = new JProgressBar();
        this.decodeProgressBar.setPreferredSize(new Dimension(10, 12));
        this.decodeProgressValueLabel = new JLabel();
        JLabel jLabel3 = new JLabel(I18nUtils.getString("ENCODING"));
        this.encodeProgressBar = new JProgressBar();
        this.encodeProgressBar.setPreferredSize(new Dimension(10, 12));
        jLabel3.setBorder(BorderFactory.createEmptyBorder());
        this.encodeProgressValueLabel = new JLabel();
        this.cancelButton = new CustomButton(null, I18nUtils.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RipperProgressDialog.this.setVisible(false);
            }
        });
        this.setDecodeProgressBarLimits(0, 100);
        this.setEncodeProgressBarLimits(0, 100);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        jPanel.add((Component)this.cover, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 20);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.totalProgressValueLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.totalProgressBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 20);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.decodeProgressValueLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.decodeProgressBar, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 20);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.encodeProgressValueLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.encodeProgressBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.add(jPanel);
    }

    public void setCover(Image image) {
        this.cover.setIcon(ImageUtils.resize(new ImageIcon(image), 90, 90));
    }

    private void setDecodeProgressBarLimits(int n, int n2) {
        this.setLimits(this.decodeProgressBar, n, n2);
    }

    public void setDecodeProgressValue(int n) {
        if (n < 0) {
            this.decodeProgressBar.setIndeterminate(true);
        } else {
            this.decodeProgressBar.setIndeterminate(false);
            this.decodeProgressBar.setValue(n);
        }
    }

    public void setDecodeProgressValue(String string) {
        this.decodeProgressValueLabel.setText(string);
    }

    private void setEncodeProgressBarLimits(int n, int n2) {
        this.setLimits(this.encodeProgressBar, n, n2);
    }

    public void setEncodeProgressValue(int n) {
        if (n < 0) {
            this.encodeProgressBar.setIndeterminate(true);
        } else {
            this.encodeProgressBar.setIndeterminate(false);
            this.encodeProgressBar.setValue(n);
        }
    }

    public void setEncodeProgressValue(String string) {
        this.encodeProgressValueLabel.setText(string);
    }

    private void setLimits(JProgressBar jProgressBar, int n, int n2) {
        jProgressBar.setMinimum(n);
        jProgressBar.setMaximum(n2);
    }

    public void setTotalProgressBarLimits(int n, int n2) {
        this.setLimits(this.totalProgressBar, n, n2);
    }

    public void setTotalProgressValue(int n) {
        this.totalProgressBar.setValue(n);
        this.totalProgressValueLabel.setText(StringUtils.getString(n, " / ", this.totalProgressBar.getMaximum()));
    }
}

