/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class ProgressDialog
extends CustomFrame {
    private static final long serialVersionUID = 5792663290880992661L;
    private JProgressBar progressBar;
    private JLabel imagelabel;
    private JLabel infoLabel;
    private JLabel currentLabel;
    private JLabel separatorLabel;
    private JLabel totalLabel;
    private JButton cancelButton;

    public ProgressDialog(String string, Component component) {
        super(string, 450, 150, component);
        this.getRootPane().setWindowDecorationStyle(3);
        this.add(this.getContent());
        this.setResizable(false);
        GuiUtils.applyComponentOrientation(this);
        this.setDefaultCloseOperation(2);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setStringPainted(true);
        this.imagelabel = new JLabel(Images.getImage("logo90x90.png"));
        this.infoLabel = new JLabel();
        this.currentLabel = new JLabel();
        this.separatorLabel = new JLabel(" / ");
        this.totalLabel = new JLabel();
        this.cancelButton = new JButton(I18nUtils.getString("CANCEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)this.imagelabel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 20, 0, 20);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 3);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.currentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.separatorLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 20);
        jPanel.add((Component)this.totalLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        return jPanel;
    }

    public void setInfoText(String string) {
        this.infoLabel.setText(string);
    }

    public void setProgressBarValue(int n) {
        this.progressBar.setValue(n);
    }

    public void setCurrentProgress(long l) {
        this.currentLabel.setText(Long.toString(l));
    }

    public void setTotalProgress(long l) {
        this.totalLabel.setText(Long.toString(l));
    }

    public void addCancelButtonActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void disableCancelButton() {
        this.cancelButton.setEnabled(false);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.imagelabel.setIcon(imageIcon);
    }

    public static void main(String[] stringArray) {
        ProgressDialog progressDialog = new ProgressDialog("test", null);
        progressDialog.setInfoText("testing");
        progressDialog.setTotalProgress(100L);
        progressDialog.setCurrentProgress(20L);
        progressDialog.setProgressBarValue(20);
        progressDialog.setVisible(true);
    }

    protected JLabel getCurrentLabel() {
        return this.currentLabel;
    }

    protected JLabel getTotalLabel() {
        return this.totalLabel;
    }
}

