/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTreeCellRendererCode;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class MultiFolderSelectionDialog
extends AbstractCustomModalDialog {
    private int checkBoxWidth;
    private static final long serialVersionUID = -1612490779910952274L;
    private Logger logger;
    private static FileSystemView fsView = FileSystemView.getFileSystemView();
    private JTree fileSystemTree;
    private JScrollPane scrollPane;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel text;
    private List<File> selectedFolders;
    private boolean cancelled;

    public MultiFolderSelectionDialog(JFrame jFrame) {
        super((Window)jFrame, 460, 530, true);
        this.checkBoxWidth = new JCheckBox().getPreferredSize().width;
        this.cancelled = true;
        this.setContent(this.getContent());
        this.setResizable(false);
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] stringArray) {
        MultiFolderSelectionDialog multiFolderSelectionDialog = new MultiFolderSelectionDialog(null);
        multiFolderSelectionDialog.startDialog(null);
        if (!multiFolderSelectionDialog.isCancelled()) {
            List<File> list = multiFolderSelectionDialog.getSelectedFolders();
            for (File file : list) {
                System.out.println(file);
            }
        }
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(null);
        this.text = new JLabel();
        this.fileSystemTree = new JTree();
        this.fileSystemTree.getSelectionModel().setSelectionMode(1);
        this.scrollPane = new JScrollPane();
        this.okButton = new CustomButton(null, I18nUtils.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiFolderSelectionDialog.this.cancelled = false;
                MultiFolderSelectionDialog.this.dispose();
            }
        });
        this.cancelButton = new CustomButton(null, I18nUtils.getString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiFolderSelectionDialog.this.dispose();
            }
        });
        this.text.setSize(430, 20);
        this.text.setLocation(10, 10);
        jPanel.add(this.text);
        this.scrollPane.setSize(430, 410);
        this.scrollPane.setLocation(10, 40);
        jPanel.add(this.scrollPane);
        this.okButton.setSize(100, 25);
        this.okButton.setLocation(230, 460);
        jPanel.add(this.okButton);
        this.cancelButton.setSize(100, 25);
        this.cancelButton.setLocation(340, 460);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public List<File> getSelectedFolders() {
        return this.selectedFolders;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    boolean isInPathOfSelectedFolders(File file) {
        String string = file.getAbsolutePath().concat(SystemProperties.FILE_SEPARATOR);
        for (File file2 : this.selectedFolders) {
            if (!file2.getAbsolutePath().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    private void setTree() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(I18nUtils.getString("PLEASE_WAIT") + "..."));
        this.fileSystemTree.setModel(defaultTreeModel);
        this.fileSystemTree.setRootVisible(true);
        this.fileSystemTree.setCellRenderer(new CheckRenderer());
        this.scrollPane.setViewportView(this.fileSystemTree);
        this.scrollPane.setVisible(true);
        new SetTreeSwingWorker().execute();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.okButton.setEnabled(false);
    }

    boolean hasDirectories(File[] fileArray) {
        for (File file : fileArray) {
            if (!file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public void startDialog(List<File> list) {
        this.cancelled = true;
        this.selectedFolders = list == null ? new ArrayList<File>() : list;
        this.setTree();
        this.setVisible(true);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static class Directory {
        private File file;
        private String displayName;

        Directory(File file, String string) {
            this.setFile(file);
            this.displayName = string;
        }

        public String toString() {
            return this.displayName;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    private class CheckRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 5564069979708271654L;
        private JCheckBox check;
        private JLabel label;
        private AbstractTreeCellRendererCode rendererCode;

        public CheckRenderer() {
            this.setLayout(new FlowLayout());
            this.check = new JCheckBox();
            this.check.setOpaque(false);
            this.add(this.check);
            this.label = new JLabel();
            this.add(this.label);
            this.rendererCode = new CheckRendererTreeCellRendererCode();
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension.height < dimension2.height) {
                n = (dimension2.height - dimension.height) / 2;
            } else {
                n2 = (dimension.height - dimension2.height) / 2;
            }
            this.check.setLocation(5, n);
            this.check.setBounds(5, n, dimension.width + 5, dimension.height);
            this.label.setLocation(dimension.width + 5, n2);
            this.label.setBounds(dimension.width + 5, n2, dimension2.width + 350, dimension2.height);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.label.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width + 10, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, "", bl, bl2, bl3, n, bl4);
            return this.rendererCode.getComponent(component, jTree, object, bl, bl2, bl3, n, bl4);
        }

        private final class CheckRendererTreeCellRendererCode
        extends AbstractTreeCellRendererCode {
            private CheckRendererTreeCellRendererCode() {
            }

            @Override
            public Component getComponent(Component component, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                String string = object.toString();
                CheckRenderer.this.setEnabled(jTree.isEnabled());
                if (object instanceof CheckNode) {
                    CheckRenderer.this.check.setSelected(((CheckNode)object).isSelected());
                    CheckRenderer.this.check.setEnabled(((CheckNode)object).isEnabled());
                    CheckRenderer.this.label.setFont(jTree.getFont());
                    CheckRenderer.this.label.setText(string);
                    CheckRenderer.this.label.setForeground(component.getForeground());
                    if (((CheckNode)object).getUserObject() instanceof Directory) {
                        Directory directory = (Directory)((CheckNode)object).getUserObject();
                        CheckRenderer.this.label.setIcon(((CheckNode)object).getIcon());
                        if (MultiFolderSelectionDialog.this.isInPathOfSelectedFolders(directory.getFile()) || ((CheckNode)object).isSelected()) {
                            CheckRenderer.this.label.setFont(CheckRenderer.this.label.getFont().deriveFont(1));
                        }
                    }
                } else if (object instanceof DefaultMutableTreeNode) {
                    CheckRenderer.this.check.setEnabled(false);
                    CheckRenderer.this.check.setSelected(false);
                    CheckRenderer.this.label.setText(string);
                    CheckRenderer.this.label.setIcon(null);
                    CheckRenderer.this.label.setFont(jTree.getFont());
                    CheckRenderer.this.label.setForeground(component.getForeground());
                }
                return CheckRenderer.this;
            }
        }
    }

    private class CheckNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 3563009061452848710L;
        private boolean isSelected;
        private boolean enabled;
        private Directory dir;
        private Icon icon;

        public CheckNode() {
            this(null, null);
        }

        public CheckNode(Object object, Icon icon) {
            this(object, true, icon);
        }

        public CheckNode(Object object, boolean bl, Icon icon) {
            super(object, bl);
            this.enabled = true;
            this.setIcon(icon);
            this.setDir((Directory)object);
            if (this.getDir() != null && MultiFolderSelectionDialog.this.selectedFolders.contains(this.getDir().getFile())) {
                this.setSelected(true);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            if (this.children != null) {
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof CheckNode)) continue;
                    CheckNode checkNode = (CheckNode)e;
                    checkNode.setSelected(bl);
                    checkNode.setEnabled(!bl);
                }
            }
            ((DefaultTreeModel)MultiFolderSelectionDialog.this.fileSystemTree.getModel()).nodeChanged(this);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public void setDir(Directory directory) {
            this.dir = directory;
        }

        public Directory getDir() {
            return this.dir;
        }
    }

    private final class SetTreeSwingWorker
    extends SwingWorker<CheckNode, Void> {
        private SetTreeSwingWorker() {
        }

        @Override
        protected CheckNode doInBackground() throws Exception {
            File[] fileArray = fsView.getRoots();
            CheckNode checkNode = new CheckNode();
            for (File file : fileArray) {
                CheckNode checkNode2 = new CheckNode(new Directory(file, fsView.getSystemDisplayName(file)), fsView.getSystemIcon(file));
                checkNode.add(checkNode2);
                Object[] objectArray = fsView.getFiles(file, true);
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    File[] fileArray2 = ((File)object).listFiles();
                    if (fileArray2 == null) continue;
                    boolean bl = MultiFolderSelectionDialog.this.hasDirectories(fileArray2);
                    CheckNode checkNode3 = new CheckNode(new Directory((File)object, fsView.getSystemDisplayName((File)object)), fsView.getSystemIcon((File)object));
                    checkNode2.add(checkNode3);
                    if (!bl) continue;
                    checkNode3.add(new DefaultMutableTreeNode("Dummy node"));
                }
            }
            return checkNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)this.get());
                MultiFolderSelectionDialog.this.fileSystemTree.setModel(defaultTreeModel);
                MultiFolderSelectionDialog.this.fileSystemTree.setRootVisible(false);
                MultiFolderSelectionDialog.this.fileSystemTree.expandRow(0);
                MultiFolderSelectionDialog.this.fileSystemTree.setSelectionRow(0);
                MultiFolderSelectionDialog.this.fileSystemTree.addMouseListener(new FileSystemTreeMouseAdapter());
                MultiFolderSelectionDialog.this.fileSystemTree.addTreeWillExpandListener(new FileSystemTreeTreeWillExpandListener());
                MultiFolderSelectionDialog.this.fileSystemTree.revalidate();
                MultiFolderSelectionDialog.this.fileSystemTree.repaint();
            }
            catch (Exception exception) {
                MultiFolderSelectionDialog.this.getLogger().internalError(exception);
            }
            finally {
                MultiFolderSelectionDialog.this.okButton.setEnabled(true);
                MultiFolderSelectionDialog.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private final class FileSystemTreeMouseAdapter
        extends MouseAdapter {
            private FileSystemTreeMouseAdapter() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    CheckNode checkNode;
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = MultiFolderSelectionDialog.this.fileSystemTree.getRowForLocation(n, n2);
                    TreePath treePath = MultiFolderSelectionDialog.this.fileSystemTree.getPathForRow(n3);
                    if (n > ((MultiFolderSelectionDialog)MultiFolderSelectionDialog.this).fileSystemTree.getPathBounds((TreePath)treePath).x + MultiFolderSelectionDialog.this.checkBoxWidth) {
                        return;
                    }
                    if (treePath != null && (checkNode = (CheckNode)treePath.getLastPathComponent()).isEnabled()) {
                        boolean bl = !checkNode.isSelected();
                        checkNode.setSelected(bl);
                        if (bl) {
                            ArrayList<File> arrayList = new ArrayList<File>();
                            for (File file : MultiFolderSelectionDialog.this.selectedFolders) {
                                if (!file.getAbsolutePath().startsWith(checkNode.getDir().getFile().getAbsolutePath())) continue;
                                arrayList.add(file);
                            }
                            for (File file : arrayList) {
                                MultiFolderSelectionDialog.this.selectedFolders.remove(file);
                            }
                            MultiFolderSelectionDialog.this.selectedFolders.add(checkNode.getDir().getFile());
                        } else {
                            MultiFolderSelectionDialog.this.selectedFolders.remove(checkNode.getDir().getFile());
                        }
                        if (n3 == 0) {
                            MultiFolderSelectionDialog.this.fileSystemTree.revalidate();
                            MultiFolderSelectionDialog.this.fileSystemTree.repaint();
                        }
                    }
                }
            }
        }

        private final class FileSystemTreeTreeWillExpandListener
        implements TreeWillExpandListener {
            private FileSystemTreeTreeWillExpandListener() {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                CheckNode checkNode = (CheckNode)treeExpansionEvent.getPath().getLastPathComponent();
                MultiFolderSelectionDialog.this.fileSystemTree.setSelectionPath(treeExpansionEvent.getPath());
                checkNode.removeAllChildren();
                checkNode.add(new DefaultMutableTreeNode(I18nUtils.getString("PLEASE_WAIT") + "..."));
                new TreeWillExpandSwingWorker(checkNode).execute();
            }

            private final class TreeWillExpandSwingWorker
            extends SwingWorker<List<CheckNode>, Void> {
                private final CheckNode selectedNode;

                private TreeWillExpandSwingWorker(CheckNode checkNode) {
                    this.selectedNode = checkNode;
                }

                @Override
                protected List<CheckNode> doInBackground() throws Exception {
                    ArrayList<CheckNode> arrayList = new ArrayList<CheckNode>();
                    Directory directory = (Directory)this.selectedNode.getUserObject();
                    Object[] objectArray = fsView.getFiles(directory.getFile(), true);
                    Arrays.sort(objectArray);
                    for (Object object : objectArray) {
                        File[] fileArray = ((File)object).listFiles();
                        if (fileArray == null) continue;
                        boolean bl = MultiFolderSelectionDialog.this.hasDirectories(fileArray);
                        CheckNode checkNode = new CheckNode(new Directory((File)object, fsView.getSystemDisplayName((File)object)), fsView.getSystemIcon((File)object));
                        arrayList.add(checkNode);
                        if (bl) {
                            checkNode.add(new DefaultMutableTreeNode("Dummy node"));
                        }
                        checkNode.setSelected(this.selectedNode.isSelected() || MultiFolderSelectionDialog.this.selectedFolders.contains(object));
                        checkNode.setEnabled(!this.selectedNode.isSelected());
                    }
                    return arrayList;
                }

                @Override
                protected void done() {
                    this.selectedNode.removeAllChildren();
                    try {
                        List list = (List)this.get();
                        for (CheckNode checkNode : list) {
                            this.selectedNode.add(checkNode);
                        }
                        ((DefaultTreeModel)MultiFolderSelectionDialog.this.fileSystemTree.getModel()).reload(this.selectedNode);
                    }
                    catch (InterruptedException interruptedException) {
                        MultiFolderSelectionDialog.this.getLogger().internalError(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        MultiFolderSelectionDialog.this.getLogger().internalError(executionException);
                    }
                }
            }
        }
    }
}

