/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomWindow;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public final class ExtendedToolTip
extends AbstractCustomWindow {
    private static final long serialVersionUID = -5041702404982493070L;
    private static final Dimension IMAGE_DIMENSION = new Dimension(300, 110);
    private static final Dimension NO_IMAGE_DIMENSION = new Dimension(200, 65);
    private JLabel image;
    private JLabel line1;
    private JLabel line2;
    private JLabel line3;

    public ExtendedToolTip() {
        super(null, ExtendedToolTip.IMAGE_DIMENSION.width, ExtendedToolTip.IMAGE_DIMENSION.height);
        this.setFocusableWindowState(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(GuiUtils.getBorderColor()));
        this.image = new JLabel();
        this.image.setBorder((Border)new DropShadowBorder());
        this.line1 = new JLabel();
        this.line1.setFont(Fonts.getGeneralBoldFont());
        this.line2 = new JLabel();
        this.line3 = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.image, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)this.line1, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel.add((Component)this.line2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel.add((Component)this.line3, gridBagConstraints);
        this.add(jPanel);
        GuiUtils.applyComponentOrientation(this);
    }

    public void setLine1(String string) {
        this.line1.setText(string);
    }

    public void setLine2(String string) {
        this.line2.setText(string);
    }

    public void setImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.image.setIcon(ImageUtils.scaleImageBicubic(imageIcon.getImage(), 150, 100));
            this.image.setVisible(true);
        } else {
            this.image.setIcon(null);
            this.image.setVisible(false);
        }
    }

    public void setLine3(String string) {
        this.line3.setText(string);
    }

    public static boolean canObjectBeShownInExtendedToolTip(Object object) {
        if (object instanceof TreeObject) {
            return ((TreeObject)object).isExtendedToolTipSupported();
        }
        return false;
    }

    public void setToolTipContent(Object object) {
        this.setImage(null);
        if (object instanceof TreeObject) {
            ((TreeObject)object).setExtendedToolTip(this);
        }
    }

    public static ImageIcon getImage(Object object) {
        if (object instanceof TreeObject) {
            return ((TreeObject)object).getExtendedToolTipImage();
        }
        return null;
    }

    public void setSizeToFitImage(boolean bl) {
        this.setSize(bl ? IMAGE_DIMENSION : NO_IMAGE_DIMENSION);
    }
}

