/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableCellEditor;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.TagAttributesReviewed;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;

public final class ReviewImportTreeTableModel
extends AbstractTreeTableModel {
    private static final long serialVersionUID = 1997644065009669746L;
    private List<File> folders;
    private List<AudioFile> audioFilesToImport;
    private HashMap<File, List<File>> foldersMap = new HashMap();
    private JXTreeTable treeTable;
    private static final String ROOT = "ROOT";
    private TagAttributesReviewed tagAttributesReviewed;

    public ReviewImportTreeTableModel(List<File> list, List<AudioFile> list2, JXTreeTable jXTreeTable) {
        super((Object)new DefaultMutableTreeTableNode((Object)ROOT));
        this.folders = list;
        this.audioFilesToImport = list2;
        this.treeTable = jXTreeTable;
        this.tagAttributesReviewed = new TagAttributesReviewed();
        Collections.sort(this.folders);
    }

    public void setCellEditors() {
        for (int i = 0; i < this.tagAttributesReviewed.getTagAttributesCount(); ++i) {
            TableCellEditor tableCellEditor = this.tagAttributesReviewed.getCellEditorForTagAttribute(i);
            if (tableCellEditor == null) continue;
            this.treeTable.getColumnExt(i + 1).setCellEditor(tableCellEditor);
        }
    }

    private boolean isRoot(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        return defaultMutableTreeTableNode.getUserObject().equals(ROOT);
    }

    public Object getChild(Object object, int n) {
        if (this.isRoot((DefaultMutableTreeTableNode)object)) {
            return new DefaultMutableTreeTableNode((Object)this.folders.get(n));
        }
        File file = ((File)((DefaultMutableTreeTableNode)object).getUserObject()).getAbsoluteFile();
        if (this.foldersMap.containsKey(file)) {
            return new DefaultMutableTreeTableNode((Object)this.foldersMap.get(file).get(n));
        }
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList);
        this.foldersMap.put(file, arrayList);
        return new DefaultMutableTreeTableNode(arrayList.get(n));
    }

    public int getChildCount(Object object) {
        if (this.isRoot((DefaultMutableTreeTableNode)object)) {
            return this.folders.size();
        }
        File file = ((File)((DefaultMutableTreeTableNode)object).getUserObject()).getAbsoluteFile();
        if (this.foldersMap.containsKey(file)) {
            return this.foldersMap.get(file).size();
        }
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList);
        this.foldersMap.put(file, arrayList);
        return arrayList.size();
    }

    public int getIndexOfChild(Object object, Object object2) {
        File file = ((File)((DefaultMutableTreeTableNode)object).getUserObject()).getAbsoluteFile();
        File file2 = ((File)((DefaultMutableTreeTableNode)object2).getUserObject()).getAbsoluteFile();
        if (this.foldersMap.containsKey(file)) {
            return this.foldersMap.get(file).indexOf(file2);
        }
        return 0;
    }

    public int getColumnCount() {
        return this.tagAttributesReviewed.getTagAttributesCount() + 1;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return I18nUtils.getString("FOLDER");
        }
        return I18nUtils.getString(this.getTagAttributesReviewed().getTagAttributeName(n - 1));
    }

    private String getValueForColumn(int n, AudioFile audioFile) {
        return this.tagAttributesReviewed.getValueForTagAttribute(n - 1, audioFile);
    }

    public Object getValueAt(Object object, int n) {
        if (this.isRoot((DefaultMutableTreeTableNode)object)) {
            return "";
        }
        File file = ((File)((DefaultMutableTreeTableNode)object).getUserObject()).getAbsoluteFile();
        if (n == 0) {
            if (this.folders.contains(file)) {
                return file.getAbsolutePath();
            }
            return file.getName();
        }
        String string = this.tagAttributesReviewed.getChangeForAttributeAndFolder(n - 1, file);
        if (string != null) {
            return string;
        }
        String string2 = "";
        for (AudioFile audioFile : this.audioFilesToImport) {
            if (!audioFile.getFile().getParentFile().equals(file)) continue;
            if (string2.equals("")) {
                string2 = this.getValueForColumn(n, audioFile);
                if (string2 != null) continue;
                string2 = "";
                continue;
            }
            if (string2.equals(this.getValueForColumn(n, audioFile))) continue;
            string2 = "";
            break;
        }
        return string2;
    }

    public boolean isCellEditable(Object object, int n) {
        return n != 0;
    }

    public void setValueAt(Object object, Object object2, int n) {
        super.setValueAt(object, object2, n);
        File file = ((File)((DefaultMutableTreeTableNode)object2).getUserObject()).getAbsoluteFile();
        this.recursiveFolderChange(n, file, (String)object);
        if (!this.foldersMap.get(file).isEmpty()) {
            this.treeTable.repaint();
        }
    }

    public void setValueForColumn(int n, String string, String string2) {
        int n2 = this.tagAttributesReviewed.getTagAttributeIndex(string);
        this.setValueAt(string2, this.treeTable.getPathForRow(n).getLastPathComponent(), n2 + 1);
    }

    private void recursiveFolderChange(int n, File file, String string) {
        this.tagAttributesReviewed.setTagAttributeForFolder(n - 1, file, string);
        for (File file2 : this.foldersMap.get(file)) {
            this.recursiveFolderChange(n, file2, string);
        }
    }

    public TagAttributesReviewed getTagAttributesReviewed() {
        return this.tagAttributesReviewed;
    }
}

