/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.tags.IncompleteTagsChecker;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;

public final class NavigationTableColumnModel
extends AbstractCommonColumnModel {
    private static final long serialVersionUID = 1071222881574684439L;

    public NavigationTableColumnModel(JTable jTable) {
        super(jTable);
        this.enableColumnChange(true);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        this.updateColumnSettings(tableColumn);
        this.updateColumnHeader(tableColumn);
        super.addColumn(tableColumn);
    }

    @Override
    protected void reapplyFilter() {
        ControllerProxy.getInstance().getNavigationController().updateTableContent(NavigationHandler.getInstance().getCurrentView().getTree());
    }

    @Override
    public AbstractTableCellRendererCode getRendererCodeFor(Class<?> clazz) {
        AbstractTableCellRendererCode abstractTableCellRendererCode = super.getRendererCodeFor(clazz);
        return new NavigationTableCellRendererCode(abstractTableCellRendererCode);
    }

    private static class NavigationTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private AbstractTableCellRendererCode renderer;

        public NavigationTableCellRendererCode(AbstractTableCellRendererCode abstractTableCellRendererCode) {
            this.renderer = abstractTableCellRendererCode;
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = this.renderer.getComponent(component, jTable, object, bl, bl2, n, n2);
            if (ApplicationState.getInstance().isHighlightIncompleteTagElements()) {
                AudioObject audioObject = ControllerProxy.getInstance().getNavigationController().getAudioObjectInNavigationTable(n);
                if (IncompleteTagsChecker.hasIncompleteTags(audioObject)) {
                    ((JLabel)component2).setForeground(Color.red);
                } else if (bl) {
                    ((JLabel)component2).setForeground(UIManager.getColor("List.selectionForeground"));
                } else {
                    ((JLabel)component2).setForeground(UIManager.getColor("List.foreground"));
                }
            }
            return component2;
        }
    }
}

