/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.debug;

import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public final class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static JButton test;
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;

    public CheckThreadViolationRepaintManager() {
        this(true);
    }

    public CheckThreadViolationRepaintManager(boolean bl) {
        this.completeCheck = bl;
    }

    static void imageUpdateTest() {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JEditorPane jEditorPane = new JEditorPane();
        jFrame.setContentPane(jEditorPane);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<html><img src=\"file:\\lala.png\"></html>");
        jFrame.setSize(300, 200);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CheckThreadViolationRepaintManager.test();
            }
        });
        System.out.println("Valid code passed...");
        CheckThreadViolationRepaintManager.repaintTest();
        System.out.println("Repaint test - correct code");
        CheckThreadViolationRepaintManager.test();
    }

    static void repaintTest() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    test = new JButton();
                    test.setSize(100, 100);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        test.repaint(test.getBounds());
        test.repaint(0, 0, 100, 100);
        test.repaint();
    }

    static void test() {
        JFrame jFrame = new JFrame("Am I on EDT?");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new JButton("JButton"));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.dispose();
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || jComponent.isShowing())) {
            StackTraceElement[] stackTraceElementArray;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.")) {
                    bl2 = true;
                }
                if (bl && "imageUpdate".equals(stackTraceElement.getMethodName())) {
                    bl3 = true;
                }
                if (!"repaint".equals(stackTraceElement.getMethodName())) continue;
                bl = true;
                bl2 = false;
            }
            if (bl3) {
                return;
            }
            if (bl && !bl2) {
                return;
            }
            if (this.lastComponent != null && jComponent == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(jComponent);
            System.out.println();
            System.out.println("EDT violation detected");
            System.out.println(jComponent);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                System.out.println("\tat " + stackTraceElement);
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean bl) {
        this.completeCheck = bl;
    }
}

