/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.sourceforge.atunes.gui.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ListAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;

public final class AutoCompleteDecorator {
    private static Object errorFeedbackAction = new TextAction("provide-error-feedback"){
        private static final long serialVersionUID = -3868819565696640330L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(actionEvent));
        }
    };

    private AutoCompleteDecorator() {
    }

    public static void decorate(JTextComponent jTextComponent, List<Object> list, boolean bl) {
        AutoCompleteDecorator.decorate(jTextComponent, list, bl, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JTextComponent jTextComponent, List<Object> list, boolean bl, ObjectToStringConverter objectToStringConverter) {
        TextComponentAdaptor textComponentAdaptor = new TextComponentAdaptor(jTextComponent, list);
        AutoCompleteDocument autoCompleteDocument = new AutoCompleteDocument((AbstractAutoCompleteAdaptor)textComponentAdaptor, bl, objectToStringConverter);
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, (AbstractAutoCompleteAdaptor)textComponentAdaptor);
    }

    public static void decorate(JList jList, JTextComponent jTextComponent) {
        AutoCompleteDecorator.decorate(jList, jTextComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JList jList, JTextComponent jTextComponent, ObjectToStringConverter objectToStringConverter) {
        ListAdaptor listAdaptor = new ListAdaptor(jList, jTextComponent, objectToStringConverter);
        AutoCompleteDocument autoCompleteDocument = new AutoCompleteDocument((AbstractAutoCompleteAdaptor)listAdaptor, true, objectToStringConverter);
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, (AbstractAutoCompleteAdaptor)listAdaptor);
    }

    public static void decorate(JComboBox jComboBox) {
        AutoCompleteDecorator.decorate(jComboBox, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(final JComboBox jComboBox, final ObjectToStringConverter objectToStringConverter) {
        boolean bl = !jComboBox.isEditable();
        jComboBox.setEditable(true);
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        ComboBoxAdaptor comboBoxAdaptor = new ComboBoxAdaptor(jComboBox);
        final AutoCompleteDocument autoCompleteDocument = new AutoCompleteDocument((AbstractAutoCompleteAdaptor)comboBoxAdaptor, bl, objectToStringConverter);
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, (AbstractAutoCompleteAdaptor)comboBoxAdaptor);
        PopUpListKeyAdapter popUpListKeyAdapter = new PopUpListKeyAdapter(jComboBox);
        jTextComponent.addKeyListener(popUpListKeyAdapter);
        if (objectToStringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
            jComboBox.setEditor((ComboBoxEditor)new AutoCompleteComboBoxEditor(jComboBox.getEditor(), objectToStringConverter));
        }
        jComboBox.addPropertyChangeListener("editor", new PropertyChangeListener((AbstractAutoCompleteAdaptor)comboBoxAdaptor, popUpListKeyAdapter){
            final /* synthetic */ AbstractAutoCompleteAdaptor val$adaptor;
            final /* synthetic */ KeyListener val$keyListener;
            {
                this.val$adaptor = abstractAutoCompleteAdaptor;
                this.val$keyListener = keyListener;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ComboBoxEditor comboBoxEditor = (ComboBoxEditor)propertyChangeEvent.getNewValue();
                if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
                    if (!(comboBoxEditor instanceof AutoCompleteComboBoxEditor) && objectToStringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
                        jComboBox.setEditor((ComboBoxEditor)new AutoCompleteComboBoxEditor(comboBoxEditor, objectToStringConverter));
                    } else {
                        AutoCompleteDecorator.decorate((JTextComponent)comboBoxEditor.getEditorComponent(), autoCompleteDocument, this.val$adaptor);
                        comboBoxEditor.getEditorComponent().addKeyListener(this.val$keyListener);
                    }
                }
            }
        });
    }

    public static void decorate(JTextComponent jTextComponent, AutoCompleteDocument autoCompleteDocument, final AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor) {
        jTextComponent.setDocument(autoCompleteDocument);
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                abstractAutoCompleteAdaptor.markEntireText();
            }
        });
        InputMap inputMap = jTextComponent.getInputMap();
        if (autoCompleteDocument.isStrictMatching()) {
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            inputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            inputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap actionMap = jTextComponent.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            actionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(actionMap.get("delete-previous"), actionMap.get("selection-backward"), abstractAutoCompleteAdaptor));
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        private static final long serialVersionUID = -5508607690462561673L;
        private Action backspace;
        private Action selectionBackward;
        private AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action action, Action action2, AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor) {
            super("nonstrict-backspace");
            this.backspace = action;
            this.selectionBackward = action2;
            this.adaptor = abstractAutoCompleteAdaptor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(actionEvent);
            } else {
                this.backspace.actionPerformed(actionEvent);
            }
        }
    }

    private static final class PopUpListKeyAdapter
    extends KeyAdapter {
        private final JComboBox comboBox;

        private PopUpListKeyAdapter(JComboBox jComboBox) {
            this.comboBox = jComboBox;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isActionKey()) {
                return;
            }
            if (this.comboBox.isDisplayable() && !this.comboBox.isPopupVisible()) {
                int n = keyEvent.getKeyCode();
                if (n == 16 || n == 17 || n == 18) {
                    return;
                }
                if (n == 27) {
                    return;
                }
                this.comboBox.setPopupVisible(true);
            }
        }
    }
}

