/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.scrobble;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.Collection;
import java.util.Collections;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.scrobble.ResponseStatus;
import net.roarsoftware.lastfm.scrobble.Source;
import net.roarsoftware.lastfm.scrobble.SubmissionData;
import net.roarsoftware.util.StringUtilities;

public class Scrobbler {
    private static final String HANDSHAKE_URL = "http://post.audioscrobbler.com/";
    private final String clientId;
    private final String clientVersion;
    private final String user;
    private String sessionId;
    private String nowPlayingUrl;
    private String submissionUrl;

    private Scrobbler(String clientId, String clientVersion, String user) {
        this.clientId = clientId;
        this.clientVersion = clientVersion;
        this.user = user;
    }

    public static Scrobbler newScrobbler(String clientId, String clientVersion, String user) {
        return new Scrobbler(clientId, clientVersion, user);
    }

    public ResponseStatus handshake(String password) throws IOException {
        long time = System.currentTimeMillis() / 1000L;
        String auth = StringUtilities.md5(StringUtilities.md5(password) + time);
        String url = String.format("%s?hs=true&p=1.2.1&c=%s&v=%s&u=%s&t=%s&a=%s", HANDSHAKE_URL, this.clientId, this.clientVersion, this.user, time, auth);
        return this.performHandshake(url);
    }

    public ResponseStatus handshake(Session session) throws IOException {
        long time = System.currentTimeMillis() / 1000L;
        String auth = StringUtilities.md5(session.getSecret() + time);
        String url = String.format("%s?hs=true&p=1.2.1&c=%s&v=%s&u=%s&t=%s&a=%s&api_key=%s&sk=%s", HANDSHAKE_URL, this.clientId, this.clientVersion, this.user, time, auth, session.getApiKey(), session.getKey());
        return this.performHandshake(url);
    }

    private ResponseStatus performHandshake(String url) throws IOException {
        ResponseStatus responseStatus;
        HttpURLConnection connection = Caller.getInstance().openConnection(url);
        InputStream is = connection.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String status = r.readLine();
        int statusCode = ResponseStatus.codeForStatus(status);
        if (statusCode == 0) {
            this.sessionId = r.readLine();
            this.nowPlayingUrl = r.readLine();
            this.submissionUrl = r.readLine();
            responseStatus = new ResponseStatus(statusCode);
        } else if (statusCode == 5) {
            responseStatus = new ResponseStatus(statusCode, status.substring(status.indexOf(32) + 1));
        } else {
            return new ResponseStatus(statusCode);
        }
        r.close();
        return responseStatus;
    }

    public ResponseStatus nowPlaying(String artist, String track) throws IOException {
        return this.nowPlaying(artist, track, null, -1, -1);
    }

    public ResponseStatus nowPlaying(String artist, String track, String album, int length, int tracknumber) throws IOException {
        if (this.sessionId == null) {
            throw new IllegalStateException("Perform successful handshake first.");
        }
        String b = album != null ? StringUtilities.encode(album) : "";
        String l = length == -1 ? "" : String.valueOf(length);
        String n = tracknumber == -1 ? "" : String.valueOf(tracknumber);
        String body = String.format("s=%s&a=%s&t=%s&b=%s&l=%s&n=%s&m=", this.sessionId, StringUtilities.encode(artist), StringUtilities.encode(track), b, l, n);
        if (Caller.getInstance().isDebugMode()) {
            System.out.println("now playing: " + body);
        }
        Proxy proxy = Caller.getInstance().getProxy();
        HttpURLConnection urlConnection = Caller.getInstance().openConnection(this.nowPlayingUrl);
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        OutputStream outputStream = urlConnection.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.write(body);
        writer.close();
        InputStream is = urlConnection.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String status = r.readLine();
        r.close();
        return new ResponseStatus(ResponseStatus.codeForStatus(status));
    }

    public ResponseStatus submit(String artist, String track, String album, int length, int tracknumber, Source source, long startTime) throws IOException {
        return this.submit(new SubmissionData(artist, track, album, length, tracknumber, source, startTime));
    }

    public ResponseStatus submit(SubmissionData data) throws IOException {
        return this.submit(Collections.singletonList(data));
    }

    public ResponseStatus submit(Collection<SubmissionData> data) throws IOException {
        if (this.sessionId == null) {
            throw new IllegalStateException("Perform successful handshake first.");
        }
        if (data.size() > 50) {
            throw new IllegalArgumentException("Max 50 submissions at once");
        }
        StringBuilder builder = new StringBuilder(data.size() * 100);
        int index = 0;
        for (SubmissionData submissionData : data) {
            builder.append(submissionData.toString(this.sessionId, index));
            builder.append('\n');
            ++index;
        }
        String body = builder.toString();
        if (Caller.getInstance().isDebugMode()) {
            System.out.println("submit: " + body);
        }
        HttpURLConnection urlConnection = Caller.getInstance().openConnection(this.submissionUrl);
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        OutputStream outputStream = urlConnection.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.write(body);
        writer.close();
        InputStream is = urlConnection.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String status = r.readLine();
        r.close();
        int statusCode = ResponseStatus.codeForStatus(status);
        if (statusCode == 5) {
            return new ResponseStatus(statusCode, status.substring(status.indexOf(32) + 1));
        }
        return new ResponseStatus(statusCode);
    }
}

