/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.HashMap;
import java.util.Locale;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Playlist;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.xml.DomElement;

public class Radio {
    private String type;
    private String stationName;
    private String stationUrl;
    private boolean supportsDiscovery;
    private Session session;
    private int expiry = -1;

    private Radio(Session session) {
        this.session = session;
    }

    public String getType() {
        return this.type;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getStationUrl() {
        return this.stationUrl;
    }

    public boolean supportsDiscovery() {
        return this.supportsDiscovery;
    }

    public int playlistExpiresIn() {
        return this.expiry;
    }

    public static Radio tune(RadioStation station, Session session) {
        return Radio.tune(station, Locale.getDefault(), session);
    }

    public static Radio tune(RadioStation station, Locale locale, Session session) {
        return Radio.tune(station.getUrl(), locale, session);
    }

    public static Radio tune(String station, Locale locale, Session session) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("station", station);
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        if (!(result = Caller.getInstance().call("radio.tune", session, params)).isSuccessful()) {
            return null;
        }
        DomElement root = result.getContentElement();
        Radio radio = new Radio(session);
        radio.type = root.getChildText("type");
        radio.stationName = root.getChildText("name");
        radio.stationUrl = root.getChildText("url");
        radio.supportsDiscovery = "1".equals(root.getChildText("type"));
        return radio;
    }

    public Playlist getPlaylist() {
        return this.getPlaylist(false, true);
    }

    public Playlist getPlaylist(boolean discovery, boolean rtp) {
        Result result = Caller.getInstance().call("radio.getPlaylist", this.session, "discovery", String.valueOf(discovery), "rtp", String.valueOf(rtp));
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement root = result.getContentElement();
        for (DomElement e : root.getChildren("link")) {
            if (!"http://www.last.fm/expiry".equals(e.getAttribute("rel"))) continue;
            this.expiry = Integer.parseInt(e.getText());
            break;
        }
        return Playlist.playlistFromElement(root);
    }

    public static class RadioStation {
        private String url;

        private RadioStation(String s) {
            this.url = s;
        }

        public String getUrl() {
            return this.url;
        }

        public static RadioStation similarArtists(String artist) {
            return new RadioStation("lastfm://artist/" + artist + "/similarartists");
        }

        public static RadioStation artistFans(String artist) {
            return new RadioStation("lastfm://artist/" + artist + "/fans");
        }

        public static RadioStation library(String user) {
            return new RadioStation("lastfm://user/" + user + "/library");
        }

        public static RadioStation neighbours(String user) {
            return new RadioStation("lastfm://user/" + user + "/neighbours");
        }

        public static RadioStation lovedTracks(String user) {
            return new RadioStation("lastfm://user/" + user + "/loved");
        }

        public static RadioStation recommended(String user) {
            return new RadioStation("lastfm://user/" + user + "/recommended");
        }

        public static RadioStation tagged(String tag) {
            return new RadioStation("lastfm://globaltags/" + tag);
        }

        public static RadioStation playlist(String playlistId) {
            return new RadioStation("lastfm://playlist/" + playlistId);
        }

        public static RadioStation personalTag(String user, String tag) {
            return new RadioStation("lastfm://usertags/" + user + "/" + tag);
        }
    }
}

