/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.modules.internetsearch.Search;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.FileNameUtils;
import org.commonjukebox.plugins.model.PluginApi;

@PluginApi
public final class DesktopUtils {
    private static Logger logger;
    private static boolean isDesktopSupported;
    private static Desktop desktop;

    private DesktopUtils() {
    }

    public static void openSearch(Search search, String string) {
        if (search != null && isDesktopSupported) {
            try {
                DesktopUtils.browse(search.getURL(string).toURI());
            }
            catch (MalformedURLException malformedURLException) {
                DesktopUtils.getLogger().error("DESKTOP     ", malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                DesktopUtils.getLogger().error("DESKTOP     ", uRISyntaxException);
            }
        }
    }

    public static void openURI(URI uRI) {
        if (isDesktopSupported) {
            DesktopUtils.browse(uRI);
        }
    }

    private static void browse(final URI uRI) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    desktop.browse(uRI);
                }
                catch (IOException iOException) {
                    DesktopUtils.getLogger().error("DESKTOP     ", iOException);
                }
            }
        });
    }

    public static void openURL(String string) {
        if (isDesktopSupported) {
            try {
                DesktopUtils.openURI(new URL(string).toURI());
            }
            catch (MalformedURLException malformedURLException) {
                DesktopUtils.getLogger().error("DESKTOP     ", malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                DesktopUtils.getLogger().error("DESKTOP     ", uRISyntaxException);
            }
        }
    }

    public static void openURL(URL uRL) {
        if (isDesktopSupported) {
            try {
                DesktopUtils.openURI(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                DesktopUtils.getLogger().error("DESKTOP     ", uRISyntaxException);
            }
        }
    }

    public static void openFile(File file) {
        if (isDesktopSupported) {
            final File file2 = SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new File(FileNameUtils.getShortPathNameW(file.getAbsolutePath())) : file;
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        desktop.open(file2);
                    }
                    catch (IOException iOException) {
                        DesktopUtils.getLogger().error("DESKTOP     ", iOException);
                    }
                    return null;
                }
            }.execute();
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    static {
        isDesktopSupported = Desktop.isDesktopSupported();
        if (isDesktopSupported) {
            desktop = Desktop.getDesktop();
        }
    }
}

