/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc.log;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.misc.log.LoggerTimer;
import net.sourceforge.atunes.utils.StringUtils;

public class Logger {
    private static Set<String> filteredCategories = new HashSet<String>();
    private org.apache.log4j.Logger logger;

    public Logger() {
        Throwable throwable = new Throwable();
        this.logger = org.apache.log4j.Logger.getLogger((String)throwable.getStackTrace()[1].getClassName());
    }

    public void debug(String string) {
        if (!Kernel.isDebug()) {
            return;
        }
        if (filteredCategories.contains(string.trim())) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = stackTraceElementArray[1].getClassName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        String string3 = stackTraceElementArray[1].getMethodName();
        this.debug(string, "--> ", string2, Character.valueOf('.'), string3, " [", LoggerTimer.getTimer(), "]");
    }

    public void debug(String string, Object ... objectArray) {
        if (!Kernel.isDebug()) {
            return;
        }
        if (filteredCategories.contains(string.trim())) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(string).append("] ");
        for (Object object : objectArray) {
            stringBuilder.append(object);
        }
        this.logger.debug((Object)stringBuilder.toString());
    }

    public void debugMethodCall(String string, String ... stringArray) {
        if (!Kernel.isDebug()) {
            return;
        }
        if (filteredCategories.contains(string.trim())) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = stackTraceElementArray[1].getClassName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        String string3 = stackTraceElementArray[1].getMethodName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--> ").append(string2).append('.').append(string3);
        if (stringArray.length > 0) {
            stringBuilder.append('{');
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
            stringBuilder.append('}');
        }
        stringBuilder.append(" [").append(LoggerTimer.getTimer()).append(']');
        this.debug(string, stringBuilder.toString());
    }

    public void error(String string, Object object) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = stackTraceElementArray[1].getClassName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        String string3 = stackTraceElementArray[1].getMethodName();
        long l = LoggerTimer.getTimer();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(string).append("] ").append("--> ").append(string2).append('.').append(string3).append(" [").append(l).append("] ").append(object);
        this.logger.error((Object)stringBuilder.toString());
        if (object instanceof Throwable) {
            StackTraceElement[] stackTraceElementArray2;
            StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2 = ((Throwable)object).getStackTrace();
            int n = stackTraceElementArray3.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray3[i];
                this.error(string, string2, string3, l, stackTraceElement);
            }
            if (((Throwable)object).getCause() != null) {
                this.error(string, StringUtils.getString(((Throwable)object).getCause().getClass().getName(), ": ", ((Throwable)object).getCause().getMessage()));
                for (StackTraceElement stackTraceElement : stackTraceElementArray3 = ((Throwable)object).getCause().getStackTrace()) {
                    this.error(string, string2, string3, l, stackTraceElement);
                }
            }
        }
    }

    private void error(String string, String string2, String string3, long l, StackTraceElement stackTraceElement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(string).append("] ").append("--> ").append(string2).append('.').append(string3).append(" [").append(l).append("]\t ").append(stackTraceElement);
        this.logger.error((Object)stringBuilder.toString());
    }

    public void info(String string, Object object) {
        if (filteredCategories.contains(string.trim())) {
            return;
        }
        this.logger.info((Object)StringUtils.getString("[", string, "] ", object));
    }

    public void internalError(Object object) {
        this.error("INTERNAL ERROR", object);
        if (object instanceof Throwable && ((Throwable)object).getCause() != null) {
            StackTraceElement[] stackTraceElementArray;
            this.error("INTERNAL ERROR", StringUtils.getString(((Throwable)object).getCause().getClass().getName(), ": ", ((Throwable)object).getCause().getMessage()));
            for (StackTraceElement stackTraceElement : stackTraceElementArray = ((Throwable)object).getCause().getStackTrace()) {
                this.error("INTERNAL ERROR", stackTraceElement);
            }
        }
        if (object instanceof InvocationTargetException) {
            this.error("INTERNAL ERROR", ((InvocationTargetException)object).getTargetException());
            this.error("INTERNAL ERROR", ((InvocationTargetException)object).getTargetException().getCause());
        }
    }

    static {
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(Logger.class.getResourceAsStream("/settings/extendedLog.properties"));
            String string = propertyResourceBundle.getString("log.filter");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                filteredCategories.add(string2);
            }
        }
        catch (Exception exception) {
            System.out.println(StringUtils.getString("/settings/extendedLog.properties", " not found or incorrect. No filters will be applied to log"));
        }
    }
}

