/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.misc;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public final class SystemProperties {
    private static String customConfigFolder = null;
    private static String customRepositoryConfigFolder = null;
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_TERMINATOR = SystemProperties.getSystemLineTerminator();
    public static final OperatingSystem OS = SystemProperties.detectOperatingSystem();
    public static final boolean IS_JAVA_6_UPDATE_10_OR_LATER = SystemProperties.isJava6Update10OrLater();

    private SystemProperties() {
    }

    private static OperatingSystem detectOperatingSystem() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("windows")) {
            return OperatingSystem.WINDOWS;
        }
        if (string.contains("mac os x")) {
            return OperatingSystem.MACOSX;
        }
        if (string.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.LINUX;
    }

    private static boolean isJava6Update10OrLater() {
        String string = System.getProperty("java.version");
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+).*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            try {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                int n4 = Integer.parseInt(matcher.group(4));
                return n == 1 && n2 == 6 && n3 >= 0 && n4 >= 10;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private static String getSystemLineTerminator() {
        if (OS == OperatingSystem.WINDOWS) {
            return "\r\n";
        }
        return "\n";
    }

    public static String getUserConfigFolder(boolean bl) {
        if (bl) {
            return "./debug";
        }
        if (customConfigFolder != null) {
            return customConfigFolder;
        }
        String string = OS == OperatingSystem.WINDOWS ? StringUtils.getString(System.getenv("APPDATA"), "/atunes") : (OS == OperatingSystem.MACOSX ? StringUtils.getString(USER_HOME, "/Library/Preferences/aTunes") : StringUtils.getString(USER_HOME, "/.atunes"));
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            File file2;
            String string3 = USER_HOME;
            String string4 = null;
            if (string3 != null && (file2 = new File(StringUtils.getString(string3, "/.aTunes"))).exists() && file2.isDirectory()) {
                string4 = file2.getAbsolutePath();
            }
            if (string4 != null && !string4.equals(string2)) {
                System.out.println(StringUtils.getString("Moving configuration from ", string4, " to ", string2));
                try {
                    FileUtils.moveDirectory((File)new File(string4), (File)new File(string2));
                    System.out.println("Configuration moved");
                }
                catch (IOException iOException) {
                    System.out.println(StringUtils.getString("Error moving configuration: ", iOException.getMessage()));
                    iOException.printStackTrace();
                }
            }
        }
        if (!file.exists() && !file.mkdir()) {
            string2 = ".";
        }
        return string2;
    }

    public static File getFileFromUserConfigFolder(String string, boolean bl) {
        String string2 = SystemProperties.getUserConfigFolder(bl);
        if (string2.equals(".")) {
            return new File(string);
        }
        return new File(StringUtils.getString(string2, "/", string));
    }

    public static void setCustomConfigFolder(String string) {
        customConfigFolder = string;
    }

    public static void setCustomRepositoryConfigFolder(String string) {
        customRepositoryConfigFolder = string;
    }

    public static String getTempFolder() {
        String string = SystemProperties.getUserConfigFolder(Kernel.isDebug());
        String string2 = StringUtils.getString(string, FILE_SEPARATOR, "temp");
        File file = new File(string2);
        if (!file.exists() && !file.mkdir()) {
            return string;
        }
        return string2;
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getCustomRepositoryConfigFolder() {
        return customRepositoryConfigFolder;
    }

    public static enum OperatingSystem {
        WINDOWS,
        LINUX,
        MACOSX,
        SOLARIS;


        public boolean isWindowsVista() {
            return this.equals((Object)WINDOWS) && System.getProperty("os.name").toLowerCase().contains("vista");
        }

        public boolean isWindows7() {
            return this.equals((Object)WINDOWS) && System.getProperty("os.name").toLowerCase().contains("7");
        }

        public boolean isOldWindows() {
            return this.equals((Object)WINDOWS) && !System.getProperty("os.name").toLowerCase().contains("vista");
        }

        public boolean isLinux() {
            return this.equals((Object)LINUX);
        }

        public boolean isMacOsX() {
            return this.equals((Object)MACOSX);
        }

        public boolean isSolaris() {
            return this.equals((Object)SOLARIS);
        }

        public boolean is64Bit() {
            return System.getProperty("os.arch").contains("64");
        }

        public String getLaunchCommand() {
            if (this.isLinux() || this.isSolaris()) {
                return new File(StringUtils.getString("./", "aTunes.sh")).getAbsolutePath();
            }
            if (this.isMacOsX()) {
                return new File(StringUtils.getString("./", "aTunes.command")).getAbsolutePath();
            }
            return new File(StringUtils.getString("./", "aTunes.exe")).getAbsolutePath();
        }
    }
}

