/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.AbstractLyricsEngine;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class LyricWikiEngine
extends AbstractLyricsEngine {
    private static final String UNFORTUNATELY_WE_ARE_NOT_LICENSED_TO_DISPLAY_THE_FULL_LYRICS = "Unfortunately, we are not licensed to display the full lyrics";
    private Logger logger;
    private static final String ARTIST_PATTERN = "%artist";
    private static final String TITLE_PATTERN = "%title";
    private static final String URL = "http://lyrics.wikia.com/%artist:%title";
    private static final String LYRICS_ELEMENT = "div";
    private static final String LYRICS_ELEMENT_ATTRIBUTE = "class";
    private static final String LYRICS_ELEMENT_ATTRIBUTE_VALUE = "lyricbox";
    private static final String RESPONSE_ENCODING = "UTF-8";

    public LyricWikiEngine(Proxy proxy) {
        super(proxy);
    }

    private static String getStringForWikiURL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.toLowerCase().split(" ")) {
            stringBuilder.append(StringUtils.convertFirstCharacterToUppercase(string2));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim().replaceAll(" ", "_");
    }

    private String getURL(String string, String string2) {
        String string3 = URL;
        String string4 = LyricWikiEngine.getStringForWikiURL(string);
        String string5 = LyricWikiEngine.getStringForWikiURL(string2);
        string3 = string3.replace(ARTIST_PATTERN, NetworkUtils.encodeString(string4));
        string3 = string3.replace(TITLE_PATTERN, NetworkUtils.encodeString(string5));
        return string3;
    }

    @Override
    public Lyrics getLyricsFor(String string, String string2) {
        try {
            String string3 = this.getURL(string, string2);
            String string4 = LyricWikiEngine.readURL(this.getConnection(string3), RESPONSE_ENCODING);
            String string5 = this.extractLyrics(string4);
            string5 = this.reviewLyrics(string5);
            return string5 != null && !string5.isEmpty() ? new Lyrics(string5, string3) : null;
        }
        catch (UnknownHostException unknownHostException) {
            this.getLogger().error("SERVICE     ", StringUtils.getString(unknownHostException.getClass().getCanonicalName(), " (", unknownHostException.getMessage(), ")"));
            return null;
        }
        catch (IOException iOException) {
            this.getLogger().error("SERVICE     ", StringUtils.getString(iOException.getClass().getCanonicalName(), " (", iOException.getMessage(), ")"));
            return null;
        }
    }

    private String extractLyrics(String string) {
        String string2 = null;
        Source source = new Source((CharSequence)string);
        List list = source.getAllElements(LYRICS_ELEMENT);
        for (Element element : list) {
            if (!LYRICS_ELEMENT_ATTRIBUTE_VALUE.equals(element.getAttributeValue(LYRICS_ELEMENT_ATTRIBUTE))) continue;
            string2 = element.getRenderer().toString();
            List list2 = element.getChildElements();
            for (Element element2 : list2) {
                if (!"rtMatcher".equals(element2.getAttributeValue(LYRICS_ELEMENT_ATTRIBUTE))) continue;
                string2 = string2.replace(element2.getRenderer().toString().replaceAll("> ", ">").trim(), "");
            }
            return string2;
        }
        return string2;
    }

    private String reviewLyrics(String string) {
        if (string.contains(UNFORTUNATELY_WE_ARE_NOT_LICENSED_TO_DISPLAY_THE_FULL_LYRICS)) {
            return null;
        }
        return string;
    }

    @Override
    public String getLyricsProviderName() {
        return "LyricWiki";
    }

    @Override
    public String getUrlForAddingNewLyrics(String string, String string2) {
        return this.getURL(string, string2);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

