/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.io.IOException;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.utils.I18nUtils;

public abstract class AbstractChangeTagProcess
extends AbstractProcess {
    private List<AudioFile> filesToChange;

    protected AbstractChangeTagProcess(List<AudioFile> list) {
        this.filesToChange = list;
    }

    @Override
    public String getProgressDialogTitle() {
        return I18nUtils.getString("PERFORMING_CHANGES");
    }

    @Override
    protected long getProcessSize() {
        return this.filesToChange.size();
    }

    @Override
    protected boolean runProcess() {
        this.retrieveInformationBeforeChangeTags();
        boolean bl = false;
        try {
            for (int i = 0; i < this.filesToChange.size() && !this.isCanceled(); ++i) {
                this.changeTag(this.filesToChange.get(i));
                RepositoryHandler.getInstance().refreshFile(this.filesToChange.get(i));
                this.setCurrentProgress(i + 1);
            }
        }
        catch (Exception exception) {
            this.addErrorLog(exception);
            bl = true;
        }
        TagModifier.refreshAfterTagModify(this.filesToChange);
        return !bl;
    }

    @Override
    protected void runCancel() {
    }

    protected abstract void changeTag(AudioFile var1) throws IOException;

    protected void retrieveInformationBeforeChangeTags() {
    }

    protected List<AudioFile> getFilesToChange() {
        return this.filesToChange;
    }

    protected void setFilesToChange(List<AudioFile> list) {
        this.filesToChange = list;
    }
}

