/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.tag;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.utils.DateUtils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class DefaultTag
extends AbstractTag {
    private static final long serialVersionUID = 6200185803652819029L;
    private static final transient SimpleDateFormat dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DefaultTag() {
    }

    public DefaultTag(Tag tag) {
        block22: {
            this.setAlbum(tag.getFirst(FieldKey.ALBUM));
            this.setArtist(tag.getFirst(FieldKey.ARTIST));
            this.setComment(tag.getFirst(FieldKey.COMMENT));
            String string = tag.getFirst(FieldKey.GENRE);
            if (string.matches("\\(.*\\).*")) {
                string = string.substring(1, string.indexOf(41));
                try {
                    string = AbstractTag.getGenreForCode(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    this.setGenre("");
                }
            }
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && AbstractTag.getGenreForCode(n) != "") {
                    string = AbstractTag.getGenreForCode(Integer.parseInt(string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setGenre(string);
            this.setTitle(tag.getFirst(FieldKey.TITLE));
            try {
                try {
                    string = tag.getFirst(FieldKey.TRACK);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    string = "-1";
                }
                if (string.contains("/")) {
                    int n = string.indexOf(47);
                    this.setTrackNumber(Integer.parseInt(string.substring(0, n)));
                } else {
                    this.setTrackNumber(Integer.parseInt(string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setTrackNumber(-1);
            }
            try {
                this.setYear(Integer.parseInt(tag.getFirst(FieldKey.YEAR)));
            }
            catch (NumberFormatException numberFormatException) {
                this.setYear(-1);
            }
            this.setLyrics(tag.getFirst(FieldKey.LYRICS));
            this.setComposer(tag.getFirst(FieldKey.COMPOSER));
            this.setAlbumArtist(tag.getFirst(FieldKey.ALBUM_ARTIST));
            this.setInternalImage(tag.hasField(FieldKey.COVER_ART.name()));
            string = this.getTagDateField(tag);
            Date date = DateUtils.parseRFC3339Date(string);
            if (date == null) {
                try {
                    date = dateOnlyFormat.parse(string);
                }
                catch (ParseException parseException) {
                    date = null;
                }
            }
            this.setDate(date);
            String string2 = tag.getFirst(FieldKey.DISC_NO);
            if (string2 != null && !string2.trim().equals("")) {
                try {
                    this.setDiscNumber(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!string2.contains("/")) break block22;
                    int n = string2.indexOf(47);
                    try {
                        this.setDiscNumber(Integer.parseInt(string2.substring(0, n)));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public AbstractTag getTagFromProperties(EditTagInfo editTagInfo, AbstractTag abstractTag) {
        DefaultTag defaultTag = new DefaultTag();
        if (editTagInfo.isTagEdited("TITLE")) {
            defaultTag.setTitle((String)editTagInfo.get("TITLE"));
        } else {
            defaultTag.setTitle(abstractTag != null ? abstractTag.getTitle() : null);
        }
        if (editTagInfo.isTagEdited("ARTIST")) {
            defaultTag.setArtist((String)editTagInfo.get("ARTIST"));
        } else {
            defaultTag.setArtist(abstractTag != null ? abstractTag.getArtist() : null);
        }
        if (editTagInfo.isTagEdited("ALBUM")) {
            defaultTag.setAlbum((String)editTagInfo.get("ALBUM"));
        } else {
            defaultTag.setAlbum(abstractTag != null ? abstractTag.getAlbum() : null);
        }
        if (editTagInfo.isTagEdited("YEAR")) {
            try {
                defaultTag.setYear(Integer.parseInt((String)editTagInfo.get("YEAR")));
            }
            catch (NumberFormatException numberFormatException) {
                defaultTag.setYear(-1);
            }
        } else {
            defaultTag.setYear(abstractTag != null ? abstractTag.getYear() : 0);
        }
        if (editTagInfo.isTagEdited("COMMENT")) {
            defaultTag.setComment((String)editTagInfo.get("COMMENT"));
        } else {
            defaultTag.setComment(abstractTag != null ? abstractTag.getComment() : null);
        }
        if (editTagInfo.isTagEdited("TRACK")) {
            try {
                defaultTag.setTrackNumber(Integer.parseInt((String)editTagInfo.get("TRACK")));
            }
            catch (NumberFormatException numberFormatException) {
                defaultTag.setTrackNumber(-1);
            }
        } else {
            defaultTag.setTrackNumber(abstractTag != null ? abstractTag.getTrackNumber() : 0);
        }
        if (editTagInfo.isTagEdited("DISC_NUMBER")) {
            try {
                defaultTag.setDiscNumber(Integer.parseInt((String)editTagInfo.get("DISC_NUMBER")));
            }
            catch (NumberFormatException numberFormatException) {
                defaultTag.setDiscNumber(0);
            }
        } else {
            defaultTag.setDiscNumber(abstractTag != null ? abstractTag.getDiscNumber() : 1);
        }
        if (editTagInfo.isTagEdited("GENRE")) {
            String string = (String)editTagInfo.get("GENRE");
            if (string == null) {
                defaultTag.setGenre("");
            } else {
                defaultTag.setGenre(string);
            }
        } else {
            defaultTag.setGenre(abstractTag != null ? abstractTag.getGenre() : null);
        }
        if (editTagInfo.isTagEdited("LYRICS")) {
            defaultTag.setLyrics((String)editTagInfo.get("LYRICS"));
        } else {
            defaultTag.setLyrics(abstractTag != null ? abstractTag.getLyrics() : null);
        }
        if (editTagInfo.isTagEdited("COMPOSER")) {
            defaultTag.setComposer((String)editTagInfo.get("COMPOSER"));
        } else {
            defaultTag.setComposer(abstractTag != null ? abstractTag.getComposer() : null);
        }
        if (editTagInfo.isTagEdited("ALBUM_ARTIST")) {
            defaultTag.setAlbumArtist((String)editTagInfo.get("ALBUM_ARTIST"));
        } else {
            defaultTag.setAlbumArtist(abstractTag != null ? abstractTag.getAlbumArtist() : null);
        }
        return defaultTag;
    }

    private String getTagDateField(Tag tag) {
        if (tag instanceof VorbisCommentTag || tag instanceof FlacTag) {
            return tag.getFirst("DATE");
        }
        if (tag instanceof ID3v24Tag) {
            return tag.getFirst("TDRC");
        }
        if (tag instanceof ID3v23Tag) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = tag.getFirst("TYER");
            if (!string.isEmpty()) {
                stringBuilder.append(string);
                String string2 = tag.getFirst("TDAT");
                if (string2.length() >= 4) {
                    stringBuilder.append('-');
                    stringBuilder.append(string2.substring(2, 4));
                    stringBuilder.append('-');
                    stringBuilder.append(string2.substring(0, 2));
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

