/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.tag;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.utils.DateUtils;

public abstract class AbstractTag
implements Serializable {
    private static final long serialVersionUID = -4044670497563446883L;
    public static final String[] genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};
    private String title;
    private String artist;
    private String album;
    private int year;
    private Date date;
    private String comment;
    private String genre;
    private String lyrics;
    private String composer;
    private String albumArtist;
    private int trackNumber;
    private int discNumber;
    private boolean internalImage;

    public static int getGenre(String string) {
        int n = -1;
        for (int i = 0; i < genres.length; ++i) {
            if (!genres[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static final String getGenreForCode(int n) {
        return n >= 0 ? genres[n] : "";
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getComment() {
        return this.comment;
    }

    public String getComposer() {
        return this.composer;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getLyrics() {
        return this.lyrics;
    }

    public abstract AbstractTag getTagFromProperties(EditTagInfo var1, AbstractTag var2);

    public String getTitle() {
        return this.title;
    }

    public int getTrackNumber() {
        return this.trackNumber >= 0 ? this.trackNumber : 0;
    }

    public int getYear() {
        if (this.date != null) {
            Calendar calendar = DateUtils.getCalendar();
            calendar.setTime(this.date);
            return calendar.get(1);
        }
        if (this.year >= 0) {
            return this.year;
        }
        return 0;
    }

    public Date getDate() {
        return this.date;
    }

    public void setAlbum(String string) {
        this.album = string != null ? string.trim() : "";
    }

    public void setAlbumArtist(String string) {
        this.albumArtist = string != null ? string.trim() : "";
    }

    public void setArtist(String string) {
        this.artist = string != null ? string.trim() : "";
    }

    public void setComment(String string) {
        this.comment = string != null ? string.trim() : "";
    }

    public void setComposer(String string) {
        this.composer = string != null ? string.trim() : "";
    }

    public void setGenre(int n) {
        this.genre = AbstractTag.getGenreForCode(n);
    }

    public void setGenre(String string) {
        this.genre = string != null ? string.trim() : "";
    }

    public void setLyrics(String string) {
        this.lyrics = string != null ? string : "";
    }

    public void setTitle(String string) {
        this.title = string != null ? string.trim() : "";
    }

    public void setTrackNumber(int n) {
        this.trackNumber = n;
    }

    public void setYear(int n) {
        if (this.date == null) {
            this.year = n;
        }
    }

    public void setDate(Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
    }

    public boolean hasInternalImage() {
        return this.internalImage;
    }

    public void setInternalImage(boolean bl) {
        this.internalImage = bl;
    }

    public int getDiscNumber() {
        return this.discNumber >= 0 ? this.discNumber : 0;
    }

    public void setDiscNumber(int n) {
        this.discNumber = n;
    }
}

