/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Genre
implements Serializable,
TreeObject {
    private static final long serialVersionUID = -6552057266561177152L;
    private String name;
    private List<AudioFile> audioFiles;

    public Genre(String string) {
        this.name = string;
        this.audioFiles = new ArrayList<AudioFile>();
    }

    public void addAudioFile(AudioFile audioFile) {
        this.audioFiles.add(audioFile);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Genre)) {
            return false;
        }
        return ((Genre)object).name.equals(this.name);
    }

    @Override
    public List<AudioObject> getAudioObjects() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (AudioFile audioFile : this.audioFiles) {
            arrayList.add(audioFile);
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void removeAudioFile(AudioFile audioFile) {
        this.audioFiles.remove(audioFile);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getToolTip() {
        int n = this.getArtistSet().size();
        int n2 = this.getAudioObjects().size();
        return StringUtils.getString(this.getName(), " (", I18nUtils.getString("ARTISTS"), ": ", n, ", ", I18nUtils.getString("SONGS"), ": ", n2, ")");
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return true;
    }

    @Override
    public void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
        extendedToolTip.setLine1(this.name);
        int n = this.getArtistSet().size();
        extendedToolTip.setLine2(StringUtils.getString(n, " ", n > 1 ? I18nUtils.getString("ARTISTS") : I18nUtils.getString("ARTIST")));
        int n2 = this.getAudioObjects().size();
        extendedToolTip.setLine3(StringUtils.getString(n2, " ", n2 > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG")));
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        return null;
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return false;
    }

    public static String getUnknownGenre() {
        return I18nUtils.getString("UNKNOWN_GENRE");
    }

    public boolean isUnknownGenre() {
        return this.getName().equalsIgnoreCase(Genre.getUnknownGenre());
    }

    public static boolean isUnknownGenre(String string) {
        return Genre.getUnknownGenre().equalsIgnoreCase(string);
    }

    public Map<String, Artist> getArtistObjects() {
        HashMap<String, Artist> hashMap = new HashMap<String, Artist>();
        for (AudioFile audioFile : this.audioFiles) {
            String string;
            String string2 = string = !audioFile.getAlbumArtist().equals("") ? audioFile.getAlbumArtist() : audioFile.getArtist();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new Artist(string));
            }
            if (!((Artist)hashMap.get(string)).getAlbums().containsKey(audioFile.getAlbum())) {
                Album album = new Album(audioFile.getAlbum());
                album.setArtist((Artist)hashMap.get(string));
                ((Artist)hashMap.get(string)).addAlbum(album);
            }
            ((Artist)hashMap.get(string)).getAlbum(audioFile.getAlbum()).addAudioFile(audioFile);
        }
        return hashMap;
    }

    public Set<String> getArtistSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (AudioFile audioFile : this.audioFiles) {
            if (!audioFile.getAlbumArtist().equals("")) {
                hashSet.add(audioFile.getAlbumArtist());
                continue;
            }
            hashSet.add(audioFile.getArtist());
        }
        return hashSet;
    }
}

