/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.model.TreeObject;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Album
implements Serializable,
TreeObject,
Comparable<Album> {
    private static final long serialVersionUID = -1481314950918557022L;
    private String name;
    private Artist artist;
    private List<AudioFile> audioFiles;

    public Album(String string) {
        this.name = string;
        this.audioFiles = new ArrayList<AudioFile>();
    }

    public void addAudioFile(AudioFile audioFile) {
        this.audioFiles.add(audioFile);
    }

    @Override
    public int compareTo(Album album) {
        return this.getNameAndArtist().compareTo(album.getNameAndArtist());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Album)) {
            return false;
        }
        return ((Album)object).name.equals(this.name) && ((Album)object).artist.equals(this.artist);
    }

    public Artist getArtist() {
        return this.artist;
    }

    public List<AudioFile> getAudioFiles() {
        return new ArrayList<AudioFile>(this.audioFiles);
    }

    @Override
    public List<AudioObject> getAudioObjects() {
        return new ArrayList<AudioObject>(this.audioFiles);
    }

    public String getName() {
        return this.name;
    }

    public String getNameAndArtist() {
        return StringUtils.getString(this.name, " (", this.artist, ")");
    }

    public ImageIcon getPicture(ImageSize imageSize) {
        return this.audioFiles.get(0).getImage(imageSize);
    }

    public boolean hasCoverDownloaded() {
        return new File(AudioFilePictureUtils.getFileNameForCover(this.audioFiles.get(0))).exists();
    }

    public int hashCode() {
        return StringUtils.getString(this.name, this.artist).hashCode();
    }

    public void removeAudioFile(AudioFile audioFile) {
        this.audioFiles.remove(audioFile);
    }

    public void setArtist(Artist artist) {
        this.artist = artist;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getToolTip() {
        int n = this.getAudioObjects().size();
        return StringUtils.getString(this.getName(), " - ", this.getArtist(), " (", n, " ", n > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG"), ")");
    }

    @Override
    public boolean isExtendedToolTipSupported() {
        return true;
    }

    @Override
    public void setExtendedToolTip(ExtendedToolTip extendedToolTip) {
        extendedToolTip.setLine1(this.name);
        extendedToolTip.setLine2(this.artist.getName());
        int n = this.audioFiles.size();
        extendedToolTip.setLine3(StringUtils.getString(n, " ", n > 1 ? I18nUtils.getString("SONGS") : I18nUtils.getString("SONG")));
    }

    @Override
    public ImageIcon getExtendedToolTipImage() {
        return this.getPicture(ImageSize.SIZE_MAX);
    }

    @Override
    public boolean isExtendedToolTipImageSupported() {
        return true;
    }

    public static String getUnknownAlbum() {
        return I18nUtils.getString("UNKNOWN_ALBUM");
    }

    public boolean isUnknownAlbum() {
        return this.getName().equalsIgnoreCase(Album.getUnknownAlbum());
    }

    public static boolean isUnknownAlbum(String string) {
        return Album.getUnknownAlbum().equalsIgnoreCase(string);
    }
}

