/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.views.dialogs.MultiFolderSelectionDialog;
import net.sourceforge.atunes.gui.views.dialogs.ProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.RepositoryProgressDialog;
import net.sourceforge.atunes.gui.views.dialogs.ReviewImportDialog;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ConnectDeviceAction;
import net.sourceforge.atunes.kernel.actions.ExitAction;
import net.sourceforge.atunes.kernel.actions.ExportAction;
import net.sourceforge.atunes.kernel.actions.ImportToRepositoryAction;
import net.sourceforge.atunes.kernel.actions.RefreshRepositoryAction;
import net.sourceforge.atunes.kernel.actions.RipCDAction;
import net.sourceforge.atunes.kernel.actions.SelectRepositoryAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.AudioFilesRemovedListener;
import net.sourceforge.atunes.kernel.modules.repository.LoaderListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryAutoRefresher;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryLoader;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.data.Year;
import net.sourceforge.atunes.kernel.modules.repository.processes.ImportFilesProcess;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.repository.tags.TagAttributesReviewed;
import net.sourceforge.atunes.kernel.modules.search.SearchHandler;
import net.sourceforge.atunes.kernel.modules.search.searchableobjects.RepositorySearchableObject;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FilenameUtils;

public final class RepositoryHandler
extends AbstractHandler
implements LoaderListener,
AudioFilesRemovedListener {
    private static RepositoryHandler instance = new RepositoryHandler();
    private Repository repository;
    private int filesLoaded;
    private RepositoryLoader currentLoader;
    private boolean backgroundLoad = false;
    private RepositoryAutoRefresher repositoryRefresher;
    private Repository repositoryRetrievedFromCache = null;
    private List<AudioFilesRemovedListener> audioFilesRemovedListeners = new ArrayList<AudioFilesRemovedListener>();
    private RepositoryProgressDialog progressDialog;
    private MouseListener progressBarMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            RepositoryHandler.this.backgroundLoad = false;
            RepositoryHandler.this.currentLoader.setPriority(10);
            GuiHandler.getInstance().hideProgressBar();
            if (RepositoryHandler.this.progressDialog != null) {
                RepositoryHandler.this.progressDialog.showProgressDialog();
            }
            GuiHandler.getInstance().getProgressBar().removeMouseListener(RepositoryHandler.this.progressBarMouseAdapter);
        }
    };

    private RepositoryHandler() {
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    @Override
    protected void initHandler() {
        this.addAudioFilesRemovedListener(this);
    }

    @Override
    public void applicationStarted() {
        this.applyRepository();
        PlayListHandler.getInstance().setPlayLists();
        if (!Kernel.getInstance().getCommandLinePlayList().isEmpty()) {
            PlayListHandler.getInstance().addToPlayListAndPlay(Kernel.getInstance().getCommandLinePlayList());
            ControllerProxy.getInstance().getPlayListController().refreshPlayList();
        }
        SearchHandler.getInstance().registerSearchableObject(RepositorySearchableObject.getInstance());
        this.repositoryRefresher = new RepositoryAutoRefresher(this);
    }

    public static RepositoryHandler getInstance() {
        return instance;
    }

    public void addFilesAndRefresh(final List<File> list) {
        SwingUtilities.invokeLater(new ShowProgressBarRunnable());
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                RepositoryLoader.addToRepository(RepositoryHandler.this.repository, list);
                return null;
            }

            @Override
            protected void done() {
                GuiHandler.getInstance().hideProgressBar();
                GuiHandler.getInstance().showRepositoryAudioFileNumber(RepositoryHandler.this.getAudioFilesList().size(), RepositoryHandler.this.getRepositoryTotalSize(), RepositoryHandler.this.repository.getTotalDurationInSeconds());
                if (ControllerProxy.getInstance().getNavigationController() != null) {
                    ControllerProxy.getInstance().getNavigationController().notifyReload();
                }
                RepositoryHandler.getLogger().info("REPOSITORY  ", "Repository refresh done");
            }
        };
        swingWorker.execute();
    }

    public void addExternalPictureForAlbum(String string, String string2, File file) {
        RepositoryLoader.addExternalPictureForAlbum(this.repository, string, string2, file);
    }

    @Override
    public void applicationFinish() {
        if (this.repositoryRefresher != null) {
            this.repositoryRefresher.interrupt();
        }
        if (this.repository != null) {
            if (this.repository.isDirty()) {
                ApplicationStateHandler.getInstance().persistRepositoryCache(this.repository, true);
            } else {
                RepositoryHandler.getLogger().info("REPOSITORY  ", "Repository is clean");
            }
            String string = ApplicationState.getInstance().getCommandAfterAccessRepository();
            if (string != null && !string.trim().isEmpty()) {
                try {
                    Process process = Runtime.getRuntime().exec(string);
                    process.waitFor();
                    int n = process.exitValue();
                    RepositoryHandler.getLogger().info("END         ", StringUtils.getString("Command '", string, "' return code: ", n));
                }
                catch (Exception exception) {
                    RepositoryHandler.getLogger().error("END         ", exception);
                }
            }
        }
        AudioFile.getImageCache().shutdown();
    }

    public List<File> getFolders() {
        if (this.repository != null) {
            return this.repository.getFolders();
        }
        return Collections.emptyList();
    }

    public List<Album> getAlbums() {
        ArrayList<Album> arrayList = new ArrayList<Album>();
        if (this.repository != null) {
            Collection<Artist> collection = this.repository.getArtistStructure().values();
            for (Artist artist : collection) {
                arrayList.addAll(artist.getAlbums().values());
            }
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public Map<String, Artist> getArtistStructure() {
        if (this.repository != null) {
            return this.repository.getArtistStructure();
        }
        return new HashMap<String, Artist>();
    }

    public List<Artist> getArtists() {
        ArrayList<Artist> arrayList = new ArrayList<Artist>();
        if (this.repository != null) {
            arrayList.addAll(this.repository.getArtistStructure().values());
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public AudioFile getFileIfLoaded(String string) {
        return this.repository == null ? null : this.repository.getFile(string);
    }

    public Map<String, Folder> getFolderStructure() {
        if (this.repository != null) {
            return this.repository.getFolderStructure();
        }
        return new HashMap<String, Folder>();
    }

    public Map<String, Genre> getGenreStructure() {
        if (this.repository != null) {
            return this.repository.getGenreStructure();
        }
        return new HashMap<String, Genre>();
    }

    public Map<String, Year> getYearStructure() {
        if (this.repository != null) {
            return this.repository.getYearStructure();
        }
        return new HashMap<String, Year>();
    }

    public Map<String, Album> getAlbumStructure() {
        if (this.repository != null) {
            HashMap<String, Album> hashMap = new HashMap<String, Album>();
            Collection<Artist> collection = this.repository.getArtistStructure().values();
            for (Artist artist : collection) {
                for (Album album : artist.getAlbums().values()) {
                    hashMap.put(album.getNameAndArtist(), album);
                }
            }
            return hashMap;
        }
        return new HashMap<String, Album>();
    }

    public int getFoldersCount() {
        if (this.repository != null) {
            return this.repository.getFolders().size();
        }
        return 0;
    }

    public String getPathForNewAudioFilesRipped() {
        return StringUtils.getString(RepositoryHandler.getInstance().getRepositoryPath(), SystemProperties.FILE_SEPARATOR, Album.getUnknownAlbum(), " - ", DateUtils.toPathString(new Date()));
    }

    public Repository getRepository() {
        return this.repository;
    }

    public File getRepositoryFolderContainingFile(AudioFile audioFile) {
        if (this.repository == null) {
            return null;
        }
        for (File file : this.repository.getFolders()) {
            if (!audioFile.getUrl().startsWith(file.getAbsolutePath())) continue;
            return file;
        }
        return null;
    }

    public String getRepositoryPath() {
        return this.repository != null ? this.repository.getFolders().get(0).getAbsolutePath() : "";
    }

    public long getRepositoryTotalSize() {
        return this.repository != null ? this.repository.getTotalSizeInBytes() : 0L;
    }

    public int getNumberOfFiles() {
        return this.repository != null ? this.repository.countFiles() : 0;
    }

    public List<AudioFile> getAudioFilesList() {
        if (this.repository != null) {
            return this.repository.getAudioFilesList();
        }
        return new ArrayList<AudioFile>();
    }

    public Map<String, AudioFile> getAudioFilesMap() {
        if (this.repository != null) {
            return this.repository.getAudioFiles();
        }
        return new HashMap<String, AudioFile>();
    }

    public List<AudioFile> getAudioFilesForAlbums(Map<String, Album> map) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Map.Entry<String, Album> entry : map.entrySet()) {
            arrayList.addAll(entry.getValue().getAudioFiles());
        }
        return arrayList;
    }

    public List<AudioFile> getAudioFilesForArtists(Map<String, Artist> map) {
        ArrayList<AudioFile> arrayList = new ArrayList<AudioFile>();
        for (Map.Entry<String, Artist> entry : map.entrySet()) {
            arrayList.addAll(entry.getValue().getAudioFiles());
        }
        return arrayList;
    }

    public boolean isRepository(File file) {
        if (this.repository == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        for (File file2 : this.repository.getFolders()) {
            if (!string.startsWith(file2.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public void notifyCancel() {
        this.currentLoader.interruptLoad();
        this.repository = this.currentLoader.getOldRepository();
        this.notifyFinishRepositoryRead();
    }

    @Override
    public void notifyCurrentPath(final String string) {
        if (this.progressDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryHandler.this.progressDialog.getFolderLabel().setText(string);
                }
            });
        }
    }

    @Override
    public void notifyFileLoaded() {
        ++this.filesLoaded;
        if (this.filesLoaded % 25 == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RepositoryHandler.this.progressDialog != null) {
                        RepositoryHandler.this.progressDialog.getProgressLabel().setText(Integer.toString(RepositoryHandler.this.filesLoaded));
                        RepositoryHandler.this.progressDialog.getProgressBar().setValue(RepositoryHandler.this.filesLoaded);
                    }
                    GuiHandler.getInstance().getProgressBar().setValue(RepositoryHandler.this.filesLoaded);
                }
            });
        }
    }

    @Override
    public void notifyFilesInRepository(int n) {
        RepositoryHandler.getLogger().debugMethodCall("REPOSITORY  ", Integer.toString(n));
        if (this.progressDialog != null) {
            this.progressDialog.getProgressBar().setIndeterminate(false);
            this.progressDialog.getTotalFilesLabel().setText(StringUtils.getString(n));
            this.progressDialog.getProgressBar().setMaximum(n);
        }
        GuiHandler.getInstance().getProgressBar().setIndeterminate(false);
        GuiHandler.getInstance().getProgressBar().setMaximum(n);
    }

    @Override
    public void notifyFinishRead(RepositoryLoader repositoryLoader) {
        if (this.progressDialog != null) {
            this.progressDialog.setButtonsEnabled(false);
            this.progressDialog.getLabel().setText(I18nUtils.getString("STORING_REPOSITORY_INFORMATION"));
            this.progressDialog.getProgressLabel().setText("");
            this.progressDialog.getTotalFilesLabel().setText("");
            this.progressDialog.getFolderLabel().setText(" ");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : this.repository.getFolders()) {
            arrayList.add(file.getAbsolutePath());
        }
        ApplicationState.getInstance().setLastRepositoryFolders(arrayList);
        if (this.backgroundLoad) {
            GuiHandler.getInstance().hideProgressBar();
        }
        this.notifyFinishRepositoryRead();
    }

    @Override
    public void notifyFinishRefresh(RepositoryLoader repositoryLoader) {
        this.enableRepositoryActions(true);
        GuiHandler.getInstance().hideProgressBar();
        GuiHandler.getInstance().showRepositoryAudioFileNumber(this.getAudioFilesList().size(), this.getRepositoryTotalSize(), this.repository.getTotalDurationInSeconds());
        if (ControllerProxy.getInstance().getNavigationController() != null) {
            ControllerProxy.getInstance().getNavigationController().notifyReload();
        }
        RepositoryHandler.getLogger().info("REPOSITORY  ", "Repository refresh done");
        this.currentLoader = null;
    }

    private void notifyFinishRepositoryRead() {
        this.enableRepositoryActions(true);
        if (this.progressDialog != null) {
            this.progressDialog.hideProgressDialog();
            this.progressDialog.dispose();
            this.progressDialog = null;
        }
        ControllerProxy.getInstance().getNavigationController().notifyReload();
        GuiHandler.getInstance().showRepositoryAudioFileNumber(this.getAudioFilesList().size(), this.getRepositoryTotalSize(), this.repository.getTotalDurationInSeconds());
        this.currentLoader = null;
    }

    @Override
    public void notifyRemainingTime(final long l) {
        if (this.progressDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepositoryHandler.this.progressDialog.getRemainingTimeLabel().setText(StringUtils.getString(I18nUtils.getString("REMAINING_TIME"), ":   ", StringUtils.milliseconds2String(l)));
                }
            });
        }
    }

    @Override
    public void notifyReadProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControllerProxy.getInstance().getNavigationController().notifyReload();
                GuiHandler.getInstance().showRepositoryAudioFileNumber(RepositoryHandler.this.getAudioFilesList().size(), RepositoryHandler.this.getRepositoryTotalSize(), RepositoryHandler.this.repository.getTotalDurationInSeconds());
            }
        });
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new Runnable(){

            @Override
            public void run() {
                String string = ApplicationState.getInstance().getCommandBeforeAccessRepository();
                if (string != null && !string.trim().equals("")) {
                    try {
                        Process process = Runtime.getRuntime().exec(string);
                        process.waitFor();
                        int n = process.exitValue();
                        RepositoryHandler.getLogger().info("START       ", StringUtils.getString("Command '", string, "' return code: ", n));
                    }
                    catch (Exception exception) {
                        RepositoryHandler.getLogger().error("START       ", exception);
                    }
                }
                RepositoryHandler.this.repositoryRetrievedFromCache = ApplicationStateHandler.getInstance().retrieveRepositoryCache();
            }
        };
    }

    private void applyRepository() {
        Repository repository = this.repositoryRetrievedFromCache;
        if (repository != null) {
            if (!repository.exists()) {
                this.askUserForRepository(repository);
                if (!repository.exists() && !this.selectRepository(true)) {
                    this.repository = repository;
                } else if (repository.exists()) {
                    this.applyExistingRepository(repository);
                }
            } else {
                this.applyExistingRepository(repository);
            }
        } else {
            this.reloadExistingRepository();
        }
    }

    private void askUserForRepository(Repository repository) {
        Object object;
        do {
            String string = Actions.getAction(ExitAction.class).getValue("Name").toString();
            object = GuiHandler.getInstance().showMessage(StringUtils.getString(I18nUtils.getString("REPOSITORY_NOT_FOUND"), ": ", repository.getFolders().get(0)), I18nUtils.getString("REPOSITORY_NOT_FOUND"), 2, new String[]{I18nUtils.getString("RETRY"), I18nUtils.getString("SELECT_REPOSITORY"), string});
            if (!object.equals(string)) continue;
            SwingUtilities.invokeLater(new ExitRunnable());
        } while (I18nUtils.getString("RETRY").equals(object) && !repository.exists());
    }

    private void applyExistingRepository(Repository repository) {
        this.repository = repository;
        this.notifyFinishRead(null);
    }

    private void reloadExistingRepository() {
        List<String> list = ApplicationState.getInstance().getLastRepositoryFolders();
        if (list != null && !list.isEmpty()) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string : list) {
                arrayList.add(new File(string));
            }
            GuiHandler.getInstance().showMessage(I18nUtils.getString("RELOAD_REPOSITORY_MESSAGE"));
            this.retrieve(arrayList);
        } else {
            GuiHandler.getInstance().showRepositorySelectionInfoDialog();
            this.selectRepository();
        }
    }

    private void readRepository(List<File> list) {
        this.backgroundLoad = false;
        Repository repository = this.repository;
        this.repository = new Repository(list);
        this.currentLoader = new RepositoryLoader(list, repository, this.repository, false);
        this.currentLoader.addRepositoryLoaderListener(this);
        this.currentLoader.start();
    }

    private void refresh() {
        RepositoryHandler.getLogger().info("REPOSITORY  ", "Refreshing repository");
        this.filesLoaded = 0;
        Repository repository = this.repository;
        this.repository = new Repository(repository.getFolders());
        this.currentLoader = new RepositoryLoader(repository.getFolders(), repository, this.repository, true);
        this.currentLoader.addRepositoryLoaderListener(this);
        this.currentLoader.start();
    }

    public void refreshFile(AudioFile audioFile) {
        RepositoryLoader.refreshFile(this.repository, audioFile);
    }

    public void refreshRepository() {
        if (!this.repositoryIsNull()) {
            String string = StringUtils.getString(I18nUtils.getString("REFRESHING"), "...");
            GuiHandler.getInstance().showProgressBar(true, string);
            this.enableRepositoryActions(false);
            this.refresh();
        }
    }

    public void removeFolders(List<Folder> list) {
        for (Folder folder : list) {
            this.remove(folder.getAudioFiles());
            if (folder.getParentFolder() != null) {
                folder.getParentFolder().removeFolder(folder);
            }
            ControllerProxy.getInstance().getNavigationController().notifyReload();
        }
    }

    public void remove(List<AudioFile> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (AudioFile object : list) {
            RepositoryLoader.deleteFile(object);
        }
        for (AudioFilesRemovedListener audioFilesRemovedListener : this.audioFilesRemovedListeners) {
            audioFilesRemovedListener.audioFilesRemoved(list);
        }
    }

    public void rename(AudioFile audioFile, String string) {
        File file = audioFile.getFile();
        String string2 = FilenameUtils.getExtension((String)file.getAbsolutePath());
        File file2 = new File(StringUtils.getString(file.getParentFile().getAbsolutePath() + "/" + FileNameUtils.getValidFileName(string) + "." + string2));
        boolean bl = file.renameTo(file2);
        if (bl) {
            RepositoryLoader.renameFile(audioFile, file, file2);
            ControllerProxy.getInstance().getNavigationController().notifyReload();
            StatisticsHandler.getInstance().updateFileName(file.getAbsolutePath(), file2.getAbsolutePath());
        }
    }

    public boolean repositoryIsNull() {
        return this.repository == null;
    }

    public boolean retrieve(List<File> list) {
        this.enableRepositoryActions(false);
        this.progressDialog = GuiHandler.getInstance().getProgressDialog();
        this.progressDialog.showProgressDialog();
        this.progressDialog.getProgressBar().setIndeterminate(true);
        GuiHandler.getInstance().getProgressBar().setIndeterminate(true);
        this.filesLoaded = 0;
        try {
            if (list == null || list.isEmpty()) {
                this.repository = null;
                return false;
            }
            this.readRepository(list);
            return true;
        }
        catch (Exception exception) {
            this.repository = null;
            RepositoryHandler.getLogger().error("REPOSITORY  ", exception);
            return false;
        }
    }

    public boolean selectRepository() {
        return this.selectRepository(false);
    }

    private boolean selectRepository(boolean bl) {
        List<File> list;
        MultiFolderSelectionDialog multiFolderSelectionDialog = GuiHandler.getInstance().getMultiFolderSelectionDialog();
        multiFolderSelectionDialog.setTitle(I18nUtils.getString("SELECT_REPOSITORY"));
        multiFolderSelectionDialog.setText(I18nUtils.getString("SELECT_REPOSITORY_FOLDERS"));
        multiFolderSelectionDialog.startDialog(this.repository != null && !bl ? this.repository.getFolders() : null);
        if (!multiFolderSelectionDialog.isCancelled() && !(list = multiFolderSelectionDialog.getSelectedFolders()).isEmpty()) {
            this.retrieve(list);
            return true;
        }
        return false;
    }

    public void importFoldersToRepository() {
    }

    public void importFolders(List<File> list, String string) {
        ProgressDialog progressDialog = GuiHandler.getInstance().getNewProgressDialog(StringUtils.getString(I18nUtils.getString("READING_FILES_TO_IMPORT"), "..."), GuiHandler.getInstance().getFrame().getFrame());
        progressDialog.disableCancelButton();
        progressDialog.setVisible(true);
        ImportFoldersSwingWorker importFoldersSwingWorker = new ImportFoldersSwingWorker(list, string, progressDialog);
        importFoldersSwingWorker.execute();
    }

    public void addAudioFilesRemovedListener(AudioFilesRemovedListener audioFilesRemovedListener) {
        this.audioFilesRemovedListeners.add(audioFilesRemovedListener);
    }

    @Override
    public void audioFilesRemoved(List<AudioFile> list) {
        GuiHandler.getInstance().showRepositoryAudioFileNumber(this.getAudioFilesList().size(), this.getRepositoryTotalSize(), this.repository.getTotalDurationInSeconds());
    }

    public void doInBackground() {
        if (this.currentLoader != null) {
            this.backgroundLoad = true;
            this.currentLoader.setPriority(1);
            if (this.progressDialog != null) {
                this.progressDialog.hideProgressDialog();
            }
            GuiHandler.getInstance().showProgressBar(false, StringUtils.getString(I18nUtils.getString("LOADING"), "..."));
            GuiHandler.getInstance().getProgressBar().addMouseListener(this.progressBarMouseAdapter);
        }
    }

    private void enableRepositoryActions(boolean bl) {
        Actions.getAction(SelectRepositoryAction.class).setEnabled(bl);
        Actions.getAction(RefreshRepositoryAction.class).setEnabled(bl);
        Actions.getAction(ImportToRepositoryAction.class).setEnabled(bl);
        Actions.getAction(ExportAction.class).setEnabled(bl);
        Actions.getAction(ConnectDeviceAction.class).setEnabled(bl);
        Actions.getAction(RipCDAction.class).setEnabled(bl);
    }

    protected boolean isLoaderWorking() {
        return this.currentLoader != null;
    }

    protected static Logger getRepositoryHandlerLogger() {
        return RepositoryHandler.getLogger();
    }

    public String getRepositoryConfigurationFolder() {
        String string = SystemProperties.getCustomRepositoryConfigFolder();
        return string != null ? string : SystemProperties.getUserConfigFolder(Kernel.isDebug());
    }

    private static class ExitRunnable
    implements Runnable {
        private ExitRunnable() {
        }

        @Override
        public void run() {
            Actions.getAction(ExitAction.class).actionPerformed(null);
        }
    }

    private static class ShowProgressBarRunnable
    implements Runnable {
        private ShowProgressBarRunnable() {
        }

        @Override
        public void run() {
            GuiHandler.getInstance().showProgressBar(true, StringUtils.getString(I18nUtils.getString("REFRESHING"), "..."));
        }
    }

    private final class ImportFoldersSwingWorker
    extends SwingWorker<List<AudioFile>, Void> {
        private final List<File> folders;
        private final String path;
        private final ProgressDialog progressDialog;

        private ImportFoldersSwingWorker(List<File> list, String string, ProgressDialog progressDialog) {
            this.folders = list;
            this.path = string;
            this.progressDialog = progressDialog;
        }

        @Override
        protected List<AudioFile> doInBackground() throws Exception {
            return RepositoryLoader.getSongsForFolders(this.folders, new ImportFoldersLoaderListener());
        }

        @Override
        protected void done() {
            super.done();
            GuiHandler.getInstance().hideIndeterminateProgressDialog();
            try {
                Object object;
                List list = (List)this.get();
                TagAttributesReviewed tagAttributesReviewed = null;
                if (ApplicationState.getInstance().isReviewTagsBeforeImport()) {
                    object = GuiHandler.getInstance().getReviewImportDialog();
                    ((ReviewImportDialog)object).show(this.folders, list);
                    if (((ReviewImportDialog)object).isDialogCancelled()) {
                        return;
                    }
                    tagAttributesReviewed = ((ReviewImportDialog)object).getResult();
                }
                object = new ImportFilesProcess(list, this.folders, this.path, tagAttributesReviewed);
                ((AbstractProcess)object).addProcessListener(new ImportFilesProcessListener((ImportFilesProcess)object));
                ((AbstractProcess)object).execute();
            }
            catch (InterruptedException interruptedException) {
                RepositoryHandler.getLogger().error("REPOSITORY  ", interruptedException);
            }
            catch (ExecutionException executionException) {
                RepositoryHandler.getLogger().error("REPOSITORY  ", executionException);
            }
        }

        private final class ImportFoldersLoaderListener
        implements LoaderListener {
            private int filesLoaded = 0;
            private int totalFiles;

            private ImportFoldersLoaderListener() {
            }

            @Override
            public void notifyRemainingTime(long l) {
            }

            @Override
            public void notifyReadProgress() {
            }

            @Override
            public void notifyFinishRefresh(RepositoryLoader repositoryLoader) {
            }

            @Override
            public void notifyFinishRead(RepositoryLoader repositoryLoader) {
                ImportFoldersSwingWorker.this.progressDialog.setVisible(false);
            }

            @Override
            public void notifyFilesInRepository(final int n) {
                this.totalFiles = n;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportFoldersSwingWorker.this.progressDialog.setTotalProgress(n);
                    }
                });
            }

            @Override
            public void notifyFileLoaded() {
                ++this.filesLoaded;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportFoldersSwingWorker.this.progressDialog.setCurrentProgress(ImportFoldersLoaderListener.this.filesLoaded);
                        ImportFoldersSwingWorker.this.progressDialog.setProgressBarValue((int)((double)ImportFoldersLoaderListener.this.filesLoaded * 100.0 / (double)ImportFoldersLoaderListener.this.totalFiles));
                    }
                });
            }

            @Override
            public void notifyCurrentPath(String string) {
            }
        }
    }

    private final class ImportFilesProcessListener
    implements ProcessListener {
        private final ImportFilesProcess process;

        private ImportFilesProcessListener(ImportFilesProcess importFilesProcess) {
            this.process = importFilesProcess;
        }

        @Override
        public void processCanceled() {
        }

        @Override
        public void processFinished(boolean bl) {
            if (!bl) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("ERRORS_IN_IMPORT_PROCESS"));
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            } else {
                RepositoryHandler.this.addFilesAndRefresh(this.process.getFilesTransferred());
            }
        }
    }
}

