/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryLoader;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

class RepositoryAutoRefresher
extends Thread {
    private Logger logger;
    private RepositoryHandler handler;

    public RepositoryAutoRefresher(RepositoryHandler repositoryHandler) {
        this.handler = repositoryHandler;
        this.setPriority(1);
        if (ApplicationState.getInstance().getAutoRepositoryRefreshTime() != 0) {
            this.start();
        }
    }

    @Override
    public void run() {
        try {
            do {
                Thread.sleep((long)ApplicationState.getInstance().getAutoRepositoryRefreshTime() * 60000L);
                if (this.handler.repositoryIsNull() || this.handler.isLoaderWorking()) continue;
                this.getLogger().info("PROCESS     ", StringUtils.getString("Checking for repository changes... (", new SimpleDateFormat("HH:mm:ss").format(new Date()), Character.valueOf(')')));
                int n = this.handler.getAudioFilesList().size();
                int n2 = RepositoryLoader.countFilesInRepository(this.handler.getRepository());
                if (n == n2) continue;
                RepositoryHandler.getInstance().refreshRepository();
            } while (ApplicationState.getInstance().getAutoRepositoryRefreshTime() != 0);
        }
        catch (Exception exception) {
            return;
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

