/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.proxy;

import java.io.IOException;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;

public class Proxy
extends java.net.Proxy
implements Serializable {
    private static final long serialVersionUID = 7495084217081194366L;
    private String url;
    private int port;
    private String user;
    private String password;

    public Proxy(Proxy.Type type, String string, int n, String string2, String string3) throws UnknownHostException, IOException {
        super(type, new Socket(string, n).getRemoteSocketAddress());
        this.url = string;
        this.port = n;
        this.user = string2;
        this.password = string3;
    }

    public static void initProxy(final Proxy proxy) {
        if (proxy != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getUser(), proxy.getPassword().toCharArray());
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
    }

    public static Proxy getProxy(ProxyBean proxyBean) throws UnknownHostException, IOException {
        if (proxyBean == null) {
            return null;
        }
        return new Proxy(proxyBean.getType().equals("HTTP_PROXY") ? Proxy.Type.HTTP : Proxy.Type.SOCKS, proxyBean.getUrl(), proxyBean.getPort(), proxyBean.getUser(), proxyBean.getPassword());
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }
}

