/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.process;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.dialogs.ProgressDialog;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public abstract class AbstractAudioFileTransferProcess
extends AbstractProcess {
    private Collection<AudioFile> filesToTransfer;
    private List<File> filesTransferred;
    private ProgressDialog progressDialog;
    private String userSelectionWhenErrors = null;

    protected AbstractAudioFileTransferProcess(Collection<AudioFile> collection) {
        this.filesToTransfer = collection;
        this.filesTransferred = new ArrayList<File>();
        this.setOwner(GuiHandler.getInstance().getFrame().getFrame());
    }

    @Override
    protected long getProcessSize() {
        long l = 0L;
        for (AudioFile audioFile : this.filesToTransfer) {
            l += audioFile.getFile().length();
        }
        return l;
    }

    @Override
    protected ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = GuiHandler.getInstance().getNewTransferProgressDialog(this.getProgressDialogTitle(), this.getOwner());
            this.progressDialog.setInfoText(this.getProgressDialogInformation());
            this.progressDialog.setCurrentProgress(0L);
            this.progressDialog.setProgressBarValue(0);
            this.progressDialog.addCancelButtonActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractAudioFileTransferProcess.this.cancelProcess();
                    AbstractAudioFileTransferProcess.this.progressDialog.disableCancelButton();
                }
            });
        }
        return this.progressDialog;
    }

    @Override
    protected boolean runProcess() {
        boolean bl = false;
        File file = new File(this.getDestination());
        long l = 0L;
        boolean bl2 = false;
        this.addInfoLog(StringUtils.getString("Transferring ", this.filesToTransfer.size(), " files to ", file));
        Iterator<AudioFile> iterator = this.filesToTransfer.iterator();
        while (iterator.hasNext() && !this.isCanceled()) {
            AudioFile audioFile = iterator.next();
            final ArrayList<Exception> arrayList = new ArrayList<Exception>();
            File file2 = this.transferAudioFile(file, audioFile, arrayList);
            this.filesTransferred.add(file2);
            if (!arrayList.isEmpty()) {
                for (Exception exception : arrayList) {
                    this.addErrorLog(exception);
                }
                if (!bl2) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AbstractAudioFileTransferProcess.this.userSelectionWhenErrors = (String)GuiHandler.getInstance().showMessage(StringUtils.getString(I18nUtils.getString("ERROR"), ": ", ((Exception)arrayList.get(0)).getMessage()), I18nUtils.getString("ERROR"), 0, new String[]{I18nUtils.getString("IGNORE"), I18nUtils.getString("IGNORE_ALL"), I18nUtils.getString("CANCEL")});
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    if (!I18nUtils.getString("IGNORE").equals(this.userSelectionWhenErrors)) {
                        if (I18nUtils.getString("IGNORE_ALL").equals(this.userSelectionWhenErrors)) {
                            bl2 = true;
                        } else if (I18nUtils.getString("CANCEL").equals(this.userSelectionWhenErrors)) {
                            bl = true;
                            break;
                        }
                    }
                }
            }
            this.setCurrentProgress(l += audioFile.getFile().length());
        }
        this.addInfoLog("Transfer process done");
        return !bl;
    }

    @Override
    protected void runCancel() {
        for (File file : this.filesTransferred) {
            file.delete();
        }
    }

    protected abstract String getDestination();

    protected File transferAudioFile(File file, AudioFile audioFile, List<Exception> list) {
        String string = this.getDirectory(audioFile, file, false);
        String string2 = this.getName(audioFile, false);
        File file2 = new File(StringUtils.getString(string, SystemProperties.FILE_SEPARATOR, string2));
        try {
            FileUtils.copyFile((File)audioFile.getFile(), (File)file2);
        }
        catch (IOException iOException) {
            list.add(iOException);
        }
        return file2;
    }

    public List<File> getFilesTransferred() {
        return this.filesTransferred;
    }

    public String getDirectory(AudioFile audioFile, File file, boolean bl) {
        return this.getDirectory(audioFile, file, bl, ApplicationState.getInstance().getImportExportFolderPathPattern());
    }

    protected String getDirectory(AudioFile audioFile, File file, boolean bl, String string) {
        String string2 = "";
        if (string != null) {
            string2 = FileNameUtils.getValidFolderName(FileNameUtils.getNewFolderPath(string, audioFile), bl);
        }
        return StringUtils.getString(file.getAbsolutePath(), SystemProperties.FILE_SEPARATOR, string2);
    }

    public String getName(AudioFile audioFile, boolean bl) {
        return this.getName(audioFile, bl, ApplicationState.getInstance().getImportExportFileNamePattern());
    }

    protected String getName(AudioFile audioFile, boolean bl, String string) {
        String string2 = string != null ? FileNameUtils.getNewFileName(string, audioFile) : FileNameUtils.getValidFileName(audioFile.getFile().getName().replace("\\", "\\\\").replace("$", "\\$"), bl);
        return string2;
    }
}

